/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobScaleRule;
import java.io.IOException;
import java.util.List;

public final class JobScale
implements JsonSerializable<JobScale> {
    private Integer pollingInterval;
    private Integer minExecutions;
    private Integer maxExecutions;
    private List<JobScaleRule> rules;

    public Integer pollingInterval() {
        return this.pollingInterval;
    }

    public JobScale withPollingInterval(Integer pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    public Integer minExecutions() {
        return this.minExecutions;
    }

    public JobScale withMinExecutions(Integer minExecutions) {
        this.minExecutions = minExecutions;
        return this;
    }

    public Integer maxExecutions() {
        return this.maxExecutions;
    }

    public JobScale withMaxExecutions(Integer maxExecutions) {
        this.maxExecutions = maxExecutions;
        return this;
    }

    public List<JobScaleRule> rules() {
        return this.rules;
    }

    public JobScale withRules(List<JobScaleRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("pollingInterval", (Number)this.pollingInterval);
        jsonWriter.writeNumberField("minExecutions", (Number)this.minExecutions);
        jsonWriter.writeNumberField("maxExecutions", (Number)this.maxExecutions);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static JobScale fromJson(JsonReader jsonReader) throws IOException {
        return (JobScale)jsonReader.readObject(reader -> {
            JobScale deserializedJobScale = new JobScale();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("pollingInterval".equals(fieldName)) {
                    deserializedJobScale.pollingInterval = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("minExecutions".equals(fieldName)) {
                    deserializedJobScale.minExecutions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxExecutions".equals(fieldName)) {
                    deserializedJobScale.maxExecutions = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedJobScale.rules = rules = reader.readArray(reader1 -> JobScaleRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobScale;
        });
    }
}

