/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import java.io.IOException;
import java.util.List;

public final class JobPatchPropertiesProperties
implements JsonSerializable<JobPatchPropertiesProperties> {
    private String environmentId;
    private JobConfiguration configuration;
    private JobTemplate template;
    private List<String> outboundIpAddresses;
    private String eventStreamEndpoint;

    public String environmentId() {
        return this.environmentId;
    }

    public JobPatchPropertiesProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public JobConfiguration configuration() {
        return this.configuration;
    }

    public JobPatchPropertiesProperties withConfiguration(JobConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public JobTemplate template() {
        return this.template;
    }

    public JobPatchPropertiesProperties withTemplate(JobTemplate template) {
        this.template = template;
        return this;
    }

    public List<String> outboundIpAddresses() {
        return this.outboundIpAddresses;
    }

    public JobPatchPropertiesProperties withOutboundIpAddresses(List<String> outboundIpAddresses) {
        this.outboundIpAddresses = outboundIpAddresses;
        return this;
    }

    public String eventStreamEndpoint() {
        return this.eventStreamEndpoint;
    }

    public JobPatchPropertiesProperties withEventStreamEndpoint(String eventStreamEndpoint) {
        this.eventStreamEndpoint = eventStreamEndpoint;
        return this;
    }

    public void validate() {
        if (this.configuration() != null) {
            this.configuration().validate();
        }
        if (this.template() != null) {
            this.template().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeJsonField("configuration", (JsonSerializable)this.configuration);
        jsonWriter.writeJsonField("template", (JsonSerializable)this.template);
        jsonWriter.writeArrayField("outboundIpAddresses", this.outboundIpAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("eventStreamEndpoint", this.eventStreamEndpoint);
        return jsonWriter.writeEndObject();
    }

    public static JobPatchPropertiesProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobPatchPropertiesProperties)jsonReader.readObject(reader -> {
            JobPatchPropertiesProperties deserializedJobPatchPropertiesProperties = new JobPatchPropertiesProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environmentId".equals(fieldName)) {
                    deserializedJobPatchPropertiesProperties.environmentId = reader.getString();
                    continue;
                }
                if ("configuration".equals(fieldName)) {
                    deserializedJobPatchPropertiesProperties.configuration = JobConfiguration.fromJson(reader);
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedJobPatchPropertiesProperties.template = JobTemplate.fromJson(reader);
                    continue;
                }
                if ("outboundIpAddresses".equals(fieldName)) {
                    List outboundIpAddresses;
                    deserializedJobPatchPropertiesProperties.outboundIpAddresses = outboundIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("eventStreamEndpoint".equals(fieldName)) {
                    deserializedJobPatchPropertiesProperties.eventStreamEndpoint = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobPatchPropertiesProperties;
        });
    }
}

