/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.Action;
import java.io.IOException;

public final class IpSecurityRestrictionRule
implements JsonSerializable<IpSecurityRestrictionRule> {
    private String name;
    private String description;
    private String ipAddressRange;
    private Action action;
    private static final ClientLogger LOGGER = new ClientLogger(IpSecurityRestrictionRule.class);

    public String name() {
        return this.name;
    }

    public IpSecurityRestrictionRule withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public IpSecurityRestrictionRule withDescription(String description) {
        this.description = description;
        return this;
    }

    public String ipAddressRange() {
        return this.ipAddressRange;
    }

    public IpSecurityRestrictionRule withIpAddressRange(String ipAddressRange) {
        this.ipAddressRange = ipAddressRange;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public IpSecurityRestrictionRule withAction(Action action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model IpSecurityRestrictionRule"));
        }
        if (this.ipAddressRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAddressRange in model IpSecurityRestrictionRule"));
        }
        if (this.action() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property action in model IpSecurityRestrictionRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("ipAddressRange", this.ipAddressRange);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static IpSecurityRestrictionRule fromJson(JsonReader jsonReader) throws IOException {
        return (IpSecurityRestrictionRule)jsonReader.readObject(reader -> {
            IpSecurityRestrictionRule deserializedIpSecurityRestrictionRule = new IpSecurityRestrictionRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIpSecurityRestrictionRule.name = reader.getString();
                    continue;
                }
                if ("ipAddressRange".equals(fieldName)) {
                    deserializedIpSecurityRestrictionRule.ipAddressRange = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedIpSecurityRestrictionRule.action = Action.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedIpSecurityRestrictionRule.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpSecurityRestrictionRule;
        });
    }
}

