/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AzureCredentials;
import com.azure.resourcemanager.appcontainers.models.RegistryInfo;
import java.io.IOException;

public final class GithubActionConfiguration
implements JsonSerializable<GithubActionConfiguration> {
    private RegistryInfo registryInfo;
    private AzureCredentials azureCredentials;
    private String contextPath;
    private String githubPersonalAccessToken;
    private String image;
    private String publishType;
    private String os;
    private String runtimeStack;
    private String runtimeVersion;

    public RegistryInfo registryInfo() {
        return this.registryInfo;
    }

    public GithubActionConfiguration withRegistryInfo(RegistryInfo registryInfo) {
        this.registryInfo = registryInfo;
        return this;
    }

    public AzureCredentials azureCredentials() {
        return this.azureCredentials;
    }

    public GithubActionConfiguration withAzureCredentials(AzureCredentials azureCredentials) {
        this.azureCredentials = azureCredentials;
        return this;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public GithubActionConfiguration withContextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public String githubPersonalAccessToken() {
        return this.githubPersonalAccessToken;
    }

    public GithubActionConfiguration withGithubPersonalAccessToken(String githubPersonalAccessToken) {
        this.githubPersonalAccessToken = githubPersonalAccessToken;
        return this;
    }

    public String image() {
        return this.image;
    }

    public GithubActionConfiguration withImage(String image) {
        this.image = image;
        return this;
    }

    public String publishType() {
        return this.publishType;
    }

    public GithubActionConfiguration withPublishType(String publishType) {
        this.publishType = publishType;
        return this;
    }

    public String os() {
        return this.os;
    }

    public GithubActionConfiguration withOs(String os) {
        this.os = os;
        return this;
    }

    public String runtimeStack() {
        return this.runtimeStack;
    }

    public GithubActionConfiguration withRuntimeStack(String runtimeStack) {
        this.runtimeStack = runtimeStack;
        return this;
    }

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public GithubActionConfiguration withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    public void validate() {
        if (this.registryInfo() != null) {
            this.registryInfo().validate();
        }
        if (this.azureCredentials() != null) {
            this.azureCredentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("registryInfo", (JsonSerializable)this.registryInfo);
        jsonWriter.writeJsonField("azureCredentials", (JsonSerializable)this.azureCredentials);
        jsonWriter.writeStringField("contextPath", this.contextPath);
        jsonWriter.writeStringField("githubPersonalAccessToken", this.githubPersonalAccessToken);
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeStringField("publishType", this.publishType);
        jsonWriter.writeStringField("os", this.os);
        jsonWriter.writeStringField("runtimeStack", this.runtimeStack);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        return jsonWriter.writeEndObject();
    }

    public static GithubActionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (GithubActionConfiguration)jsonReader.readObject(reader -> {
            GithubActionConfiguration deserializedGithubActionConfiguration = new GithubActionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("registryInfo".equals(fieldName)) {
                    deserializedGithubActionConfiguration.registryInfo = RegistryInfo.fromJson(reader);
                    continue;
                }
                if ("azureCredentials".equals(fieldName)) {
                    deserializedGithubActionConfiguration.azureCredentials = AzureCredentials.fromJson(reader);
                    continue;
                }
                if ("contextPath".equals(fieldName)) {
                    deserializedGithubActionConfiguration.contextPath = reader.getString();
                    continue;
                }
                if ("githubPersonalAccessToken".equals(fieldName)) {
                    deserializedGithubActionConfiguration.githubPersonalAccessToken = reader.getString();
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedGithubActionConfiguration.image = reader.getString();
                    continue;
                }
                if ("publishType".equals(fieldName)) {
                    deserializedGithubActionConfiguration.publishType = reader.getString();
                    continue;
                }
                if ("os".equals(fieldName)) {
                    deserializedGithubActionConfiguration.os = reader.getString();
                    continue;
                }
                if ("runtimeStack".equals(fieldName)) {
                    deserializedGithubActionConfiguration.runtimeStack = reader.getString();
                    continue;
                }
                if ("runtimeVersion".equals(fieldName)) {
                    deserializedGithubActionConfiguration.runtimeVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGithubActionConfiguration;
        });
    }
}

