/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.DaprComponentInner;
import java.io.IOException;
import java.util.List;

public final class DaprComponentsCollection
implements JsonSerializable<DaprComponentsCollection> {
    private List<DaprComponentInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DaprComponentsCollection.class);

    public List<DaprComponentInner> value() {
        return this.value;
    }

    public DaprComponentsCollection withValue(List<DaprComponentInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DaprComponentsCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DaprComponentsCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DaprComponentsCollection)jsonReader.readObject(reader -> {
            DaprComponentsCollection deserializedDaprComponentsCollection = new DaprComponentsCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDaprComponentsCollection.value = value = reader.readArray(reader1 -> DaprComponentInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDaprComponentsCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDaprComponentsCollection;
        });
    }
}

