/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.CertificateKeyVaultProperties;
import com.azure.resourcemanager.appcontainers.models.CertificateProvisioningState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class CertificateProperties
implements JsonSerializable<CertificateProperties> {
    private CertificateProvisioningState provisioningState;
    private CertificateKeyVaultProperties certificateKeyVaultProperties;
    private String password;
    private String subjectName;
    private List<String> subjectAlternativeNames;
    private byte[] value;
    private String issuer;
    private OffsetDateTime issueDate;
    private OffsetDateTime expirationDate;
    private String thumbprint;
    private Boolean valid;
    private String publicKeyHash;

    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public CertificateKeyVaultProperties certificateKeyVaultProperties() {
        return this.certificateKeyVaultProperties;
    }

    public CertificateProperties withCertificateKeyVaultProperties(CertificateKeyVaultProperties certificateKeyVaultProperties) {
        this.certificateKeyVaultProperties = certificateKeyVaultProperties;
        return this;
    }

    public String password() {
        return this.password;
    }

    public CertificateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public String subjectName() {
        return this.subjectName;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public byte[] value() {
        return CoreUtils.clone((byte[])this.value);
    }

    public CertificateProperties withValue(byte[] value) {
        this.value = CoreUtils.clone((byte[])value);
        return this;
    }

    public String issuer() {
        return this.issuer;
    }

    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean valid() {
        return this.valid;
    }

    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    public void validate() {
        if (this.certificateKeyVaultProperties() != null) {
            this.certificateKeyVaultProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("certificateKeyVaultProperties", (JsonSerializable)this.certificateKeyVaultProperties);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeBinaryField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CertificateProperties)jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedCertificateProperties.provisioningState = CertificateProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("certificateKeyVaultProperties".equals(fieldName)) {
                    deserializedCertificateProperties.certificateKeyVaultProperties = CertificateKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCertificateProperties.password = reader.getString();
                    continue;
                }
                if ("subjectName".equals(fieldName)) {
                    deserializedCertificateProperties.subjectName = reader.getString();
                    continue;
                }
                if ("subjectAlternativeNames".equals(fieldName)) {
                    List subjectAlternativeNames;
                    deserializedCertificateProperties.subjectAlternativeNames = subjectAlternativeNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedCertificateProperties.value = reader.getBinary();
                    continue;
                }
                if ("issuer".equals(fieldName)) {
                    deserializedCertificateProperties.issuer = reader.getString();
                    continue;
                }
                if ("issueDate".equals(fieldName)) {
                    deserializedCertificateProperties.issueDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDate".equals(fieldName)) {
                    deserializedCertificateProperties.expirationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("valid".equals(fieldName)) {
                    deserializedCertificateProperties.valid = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicKeyHash".equals(fieldName)) {
                    deserializedCertificateProperties.publicKeyHash = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCertificateProperties;
        });
    }
}

