/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.AccessMode;
import java.io.IOException;

public final class AzureFileProperties
implements JsonSerializable<AzureFileProperties> {
    private String accountName;
    private String accountKey;
    private AccessMode accessMode;
    private String shareName;

    public String accountName() {
        return this.accountName;
    }

    public AzureFileProperties withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String accountKey() {
        return this.accountKey;
    }

    public AzureFileProperties withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public AccessMode accessMode() {
        return this.accessMode;
    }

    public AzureFileProperties withAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public String shareName() {
        return this.shareName;
    }

    public AzureFileProperties withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        jsonWriter.writeStringField("shareName", this.shareName);
        return jsonWriter.writeEndObject();
    }

    public static AzureFileProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileProperties)jsonReader.readObject(reader -> {
            AzureFileProperties deserializedAzureFileProperties = new AzureFileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAzureFileProperties.accountName = reader.getString();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureFileProperties.accountKey = reader.getString();
                    continue;
                }
                if ("accessMode".equals(fieldName)) {
                    deserializedAzureFileProperties.accessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                if ("shareName".equals(fieldName)) {
                    deserializedAzureFileProperties.shareName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFileProperties;
        });
    }
}

