/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.AuthConfigInner;
import java.io.IOException;
import java.util.List;

public final class AuthConfigCollection
implements JsonSerializable<AuthConfigCollection> {
    private List<AuthConfigInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(AuthConfigCollection.class);

    public List<AuthConfigInner> value() {
        return this.value;
    }

    public AuthConfigCollection withValue(List<AuthConfigInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model AuthConfigCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AuthConfigCollection fromJson(JsonReader jsonReader) throws IOException {
        return (AuthConfigCollection)jsonReader.readObject(reader -> {
            AuthConfigCollection deserializedAuthConfigCollection = new AuthConfigCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedAuthConfigCollection.value = value = reader.readArray(reader1 -> AuthConfigInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedAuthConfigCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAuthConfigCollection;
        });
    }
}

