/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.SessionPoolInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedIdentitySetting;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPool;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import com.azure.resourcemanager.appcontainers.models.SessionPoolUpdatableProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SessionPoolImpl
implements SessionPool,
SessionPool.Definition,
SessionPool.Update {
    private SessionPoolInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String sessionPoolName;
    private SessionPoolUpdatableProperties updateSessionPoolEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String environmentId() {
        return this.innerModel().environmentId();
    }

    @Override
    public ContainerType containerType() {
        return this.innerModel().containerType();
    }

    @Override
    public PoolManagementType poolManagementType() {
        return this.innerModel().poolManagementType();
    }

    @Override
    public Integer nodeCount() {
        return this.innerModel().nodeCount();
    }

    @Override
    public ScaleConfiguration scaleConfiguration() {
        return this.innerModel().scaleConfiguration();
    }

    @Override
    public List<SessionPoolSecret> secrets() {
        List<SessionPoolSecret> inner = this.innerModel().secrets();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.innerModel().dynamicPoolConfiguration();
    }

    @Override
    public CustomContainerTemplate customContainerTemplate() {
        return this.innerModel().customContainerTemplate();
    }

    @Override
    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.innerModel().sessionNetworkConfiguration();
    }

    @Override
    public String poolManagementEndpoint() {
        return this.innerModel().poolManagementEndpoint();
    }

    @Override
    public SessionPoolProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<ManagedIdentitySetting> managedIdentitySettings() {
        List<ManagedIdentitySetting> inner = this.innerModel().managedIdentitySettings();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public SessionPoolInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public SessionPoolImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public SessionPool create() {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSessionPools().createOrUpdate(this.resourceGroupName, this.sessionPoolName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public SessionPool create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSessionPools().createOrUpdate(this.resourceGroupName, this.sessionPoolName, this.innerModel(), context);
        return this;
    }

    SessionPoolImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new SessionPoolInner();
        this.serviceManager = serviceManager;
        this.sessionPoolName = name;
    }

    @Override
    public SessionPoolImpl update() {
        this.updateSessionPoolEnvelope = new SessionPoolUpdatableProperties();
        return this;
    }

    @Override
    public SessionPool apply() {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSessionPools().update(this.resourceGroupName, this.sessionPoolName, this.updateSessionPoolEnvelope, Context.NONE);
        return this;
    }

    @Override
    public SessionPool apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContainerAppsSessionPools().update(this.resourceGroupName, this.sessionPoolName, this.updateSessionPoolEnvelope, context);
        return this;
    }

    SessionPoolImpl(SessionPoolInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sessionPoolName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sessionPools");
    }

    @Override
    public SessionPool refresh() {
        this.innerObject = (SessionPoolInner)((Object)this.serviceManager.serviceClient().getContainerAppsSessionPools().getByResourceGroupWithResponse(this.resourceGroupName, this.sessionPoolName, Context.NONE).getValue());
        return this;
    }

    @Override
    public SessionPool refresh(Context context) {
        this.innerObject = (SessionPoolInner)((Object)this.serviceManager.serviceClient().getContainerAppsSessionPools().getByResourceGroupWithResponse(this.resourceGroupName, this.sessionPoolName, context).getValue());
        return this;
    }

    @Override
    public SessionPoolImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public SessionPoolImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public SessionPoolImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateSessionPoolEnvelope.withTags(tags);
        return this;
    }

    @Override
    public SessionPoolImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateSessionPoolEnvelope.withIdentity(identity);
        return this;
    }

    @Override
    public SessionPoolImpl withEnvironmentId(String environmentId) {
        this.innerModel().withEnvironmentId(environmentId);
        return this;
    }

    @Override
    public SessionPoolImpl withContainerType(ContainerType containerType) {
        this.innerModel().withContainerType(containerType);
        return this;
    }

    @Override
    public SessionPoolImpl withPoolManagementType(PoolManagementType poolManagementType) {
        this.innerModel().withPoolManagementType(poolManagementType);
        return this;
    }

    @Override
    public SessionPoolImpl withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withScaleConfiguration(scaleConfiguration);
            return this;
        }
        this.updateSessionPoolEnvelope.withScaleConfiguration(scaleConfiguration);
        return this;
    }

    @Override
    public SessionPoolImpl withSecrets(List<SessionPoolSecret> secrets) {
        if (this.isInCreateMode()) {
            this.innerModel().withSecrets(secrets);
            return this;
        }
        this.updateSessionPoolEnvelope.withSecrets(secrets);
        return this;
    }

    @Override
    public SessionPoolImpl withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withDynamicPoolConfiguration(dynamicPoolConfiguration);
            return this;
        }
        this.updateSessionPoolEnvelope.withDynamicPoolConfiguration(dynamicPoolConfiguration);
        return this;
    }

    @Override
    public SessionPoolImpl withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        if (this.isInCreateMode()) {
            this.innerModel().withCustomContainerTemplate(customContainerTemplate);
            return this;
        }
        this.updateSessionPoolEnvelope.withCustomContainerTemplate(customContainerTemplate);
        return this;
    }

    @Override
    public SessionPoolImpl withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        if (this.isInCreateMode()) {
            this.innerModel().withSessionNetworkConfiguration(sessionNetworkConfiguration);
            return this;
        }
        this.updateSessionPoolEnvelope.withSessionNetworkConfiguration(sessionNetworkConfiguration);
        return this;
    }

    @Override
    public SessionPoolImpl withManagedIdentitySettings(List<ManagedIdentitySetting> managedIdentitySettings) {
        this.innerModel().withManagedIdentitySettings(managedIdentitySettings);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

