/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appcontainers.ContainerAppsApiManager;
import com.azure.resourcemanager.appcontainers.fluent.models.JobInner;
import com.azure.resourcemanager.appcontainers.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appcontainers.models.ContainerAppJobExecutions;
import com.azure.resourcemanager.appcontainers.models.Job;
import com.azure.resourcemanager.appcontainers.models.JobConfiguration;
import com.azure.resourcemanager.appcontainers.models.JobExecutionBase;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import com.azure.resourcemanager.appcontainers.models.JobPatchProperties;
import com.azure.resourcemanager.appcontainers.models.JobPatchPropertiesProperties;
import com.azure.resourcemanager.appcontainers.models.JobProvisioningState;
import com.azure.resourcemanager.appcontainers.models.JobSecretsCollection;
import com.azure.resourcemanager.appcontainers.models.JobTemplate;
import com.azure.resourcemanager.appcontainers.models.ManagedServiceIdentity;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class JobImpl
implements Job,
Job.Definition,
Job.Update {
    private JobInner innerObject;
    private final ContainerAppsApiManager serviceManager;
    private String resourceGroupName;
    private String jobName;
    private JobPatchProperties updateJobEnvelope;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public JobProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String environmentId() {
        return this.innerModel().environmentId();
    }

    @Override
    public String workloadProfileName() {
        return this.innerModel().workloadProfileName();
    }

    @Override
    public JobConfiguration configuration() {
        return this.innerModel().configuration();
    }

    @Override
    public JobTemplate template() {
        return this.innerModel().template();
    }

    @Override
    public List<String> outboundIpAddresses() {
        List<String> inner = this.innerModel().outboundIpAddresses();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String eventStreamEndpoint() {
        return this.innerModel().eventStreamEndpoint();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public JobInner innerModel() {
        return this.innerObject;
    }

    private ContainerAppsApiManager manager() {
        return this.serviceManager;
    }

    @Override
    public JobImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Job create() {
        this.innerObject = this.serviceManager.serviceClient().getJobs().createOrUpdate(this.resourceGroupName, this.jobName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Job create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJobs().createOrUpdate(this.resourceGroupName, this.jobName, this.innerModel(), context);
        return this;
    }

    JobImpl(String name, ContainerAppsApiManager serviceManager) {
        this.innerObject = new JobInner();
        this.serviceManager = serviceManager;
        this.jobName = name;
    }

    @Override
    public JobImpl update() {
        this.updateJobEnvelope = new JobPatchProperties();
        return this;
    }

    @Override
    public Job apply() {
        this.innerObject = this.serviceManager.serviceClient().getJobs().update(this.resourceGroupName, this.jobName, this.updateJobEnvelope, Context.NONE);
        return this;
    }

    @Override
    public Job apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getJobs().update(this.resourceGroupName, this.jobName, this.updateJobEnvelope, context);
        return this;
    }

    JobImpl(JobInner innerObject, ContainerAppsApiManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.jobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "jobs");
    }

    @Override
    public Job refresh() {
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().getByResourceGroupWithResponse(this.resourceGroupName, this.jobName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Job refresh(Context context) {
        this.innerObject = (JobInner)((Object)this.serviceManager.serviceClient().getJobs().getByResourceGroupWithResponse(this.resourceGroupName, this.jobName, context).getValue());
        return this;
    }

    @Override
    public JobExecutionBase start() {
        return this.serviceManager.jobs().start(this.resourceGroupName, this.jobName);
    }

    @Override
    public JobExecutionBase start(JobExecutionTemplate template, Context context) {
        return this.serviceManager.jobs().start(this.resourceGroupName, this.jobName, template, context);
    }

    @Override
    public ContainerAppJobExecutions stopMultipleExecutions() {
        return this.serviceManager.jobs().stopMultipleExecutions(this.resourceGroupName, this.jobName);
    }

    @Override
    public ContainerAppJobExecutions stopMultipleExecutions(Context context) {
        return this.serviceManager.jobs().stopMultipleExecutions(this.resourceGroupName, this.jobName, context);
    }

    @Override
    public Response<JobSecretsCollection> listSecretsWithResponse(Context context) {
        return this.serviceManager.jobs().listSecretsWithResponse(this.resourceGroupName, this.jobName, context);
    }

    @Override
    public JobSecretsCollection listSecrets() {
        return this.serviceManager.jobs().listSecrets(this.resourceGroupName, this.jobName);
    }

    @Override
    public JobImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public JobImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public JobImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateJobEnvelope.withTags(tags);
        return this;
    }

    @Override
    public JobImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateJobEnvelope.withIdentity(identity);
        return this;
    }

    @Override
    public JobImpl withEnvironmentId(String environmentId) {
        this.innerModel().withEnvironmentId(environmentId);
        return this;
    }

    @Override
    public JobImpl withWorkloadProfileName(String workloadProfileName) {
        this.innerModel().withWorkloadProfileName(workloadProfileName);
        return this;
    }

    @Override
    public JobImpl withConfiguration(JobConfiguration configuration) {
        this.innerModel().withConfiguration(configuration);
        return this;
    }

    @Override
    public JobImpl withTemplate(JobTemplate template) {
        this.innerModel().withTemplate(template);
        return this;
    }

    @Override
    public JobImpl withProperties(JobPatchPropertiesProperties properties) {
        this.updateJobEnvelope.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

