/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ContainerType;
import com.azure.resourcemanager.appcontainers.models.CustomContainerTemplate;
import com.azure.resourcemanager.appcontainers.models.DynamicPoolConfiguration;
import com.azure.resourcemanager.appcontainers.models.ManagedIdentitySetting;
import com.azure.resourcemanager.appcontainers.models.PoolManagementType;
import com.azure.resourcemanager.appcontainers.models.ScaleConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionNetworkConfiguration;
import com.azure.resourcemanager.appcontainers.models.SessionPoolProvisioningState;
import com.azure.resourcemanager.appcontainers.models.SessionPoolSecret;
import java.io.IOException;
import java.util.List;

public final class SessionPoolProperties
implements JsonSerializable<SessionPoolProperties> {
    private String environmentId;
    private ContainerType containerType;
    private PoolManagementType poolManagementType;
    private Integer nodeCount;
    private ScaleConfiguration scaleConfiguration;
    private List<SessionPoolSecret> secrets;
    private DynamicPoolConfiguration dynamicPoolConfiguration;
    private CustomContainerTemplate customContainerTemplate;
    private SessionNetworkConfiguration sessionNetworkConfiguration;
    private String poolManagementEndpoint;
    private SessionPoolProvisioningState provisioningState;
    private List<ManagedIdentitySetting> managedIdentitySettings;

    public String environmentId() {
        return this.environmentId;
    }

    public SessionPoolProperties withEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public ContainerType containerType() {
        return this.containerType;
    }

    public SessionPoolProperties withContainerType(ContainerType containerType) {
        this.containerType = containerType;
        return this;
    }

    public PoolManagementType poolManagementType() {
        return this.poolManagementType;
    }

    public SessionPoolProperties withPoolManagementType(PoolManagementType poolManagementType) {
        this.poolManagementType = poolManagementType;
        return this;
    }

    public Integer nodeCount() {
        return this.nodeCount;
    }

    public ScaleConfiguration scaleConfiguration() {
        return this.scaleConfiguration;
    }

    public SessionPoolProperties withScaleConfiguration(ScaleConfiguration scaleConfiguration) {
        this.scaleConfiguration = scaleConfiguration;
        return this;
    }

    public List<SessionPoolSecret> secrets() {
        return this.secrets;
    }

    public SessionPoolProperties withSecrets(List<SessionPoolSecret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public DynamicPoolConfiguration dynamicPoolConfiguration() {
        return this.dynamicPoolConfiguration;
    }

    public SessionPoolProperties withDynamicPoolConfiguration(DynamicPoolConfiguration dynamicPoolConfiguration) {
        this.dynamicPoolConfiguration = dynamicPoolConfiguration;
        return this;
    }

    public CustomContainerTemplate customContainerTemplate() {
        return this.customContainerTemplate;
    }

    public SessionPoolProperties withCustomContainerTemplate(CustomContainerTemplate customContainerTemplate) {
        this.customContainerTemplate = customContainerTemplate;
        return this;
    }

    public SessionNetworkConfiguration sessionNetworkConfiguration() {
        return this.sessionNetworkConfiguration;
    }

    public SessionPoolProperties withSessionNetworkConfiguration(SessionNetworkConfiguration sessionNetworkConfiguration) {
        this.sessionNetworkConfiguration = sessionNetworkConfiguration;
        return this;
    }

    public String poolManagementEndpoint() {
        return this.poolManagementEndpoint;
    }

    public SessionPoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<ManagedIdentitySetting> managedIdentitySettings() {
        return this.managedIdentitySettings;
    }

    public SessionPoolProperties withManagedIdentitySettings(List<ManagedIdentitySetting> managedIdentitySettings) {
        this.managedIdentitySettings = managedIdentitySettings;
        return this;
    }

    public void validate() {
        if (this.scaleConfiguration() != null) {
            this.scaleConfiguration().validate();
        }
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.dynamicPoolConfiguration() != null) {
            this.dynamicPoolConfiguration().validate();
        }
        if (this.customContainerTemplate() != null) {
            this.customContainerTemplate().validate();
        }
        if (this.sessionNetworkConfiguration() != null) {
            this.sessionNetworkConfiguration().validate();
        }
        if (this.managedIdentitySettings() != null) {
            this.managedIdentitySettings().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentId", this.environmentId);
        jsonWriter.writeStringField("containerType", this.containerType == null ? null : this.containerType.toString());
        jsonWriter.writeStringField("poolManagementType", this.poolManagementType == null ? null : this.poolManagementType.toString());
        jsonWriter.writeJsonField("scaleConfiguration", (JsonSerializable)this.scaleConfiguration);
        jsonWriter.writeArrayField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dynamicPoolConfiguration", (JsonSerializable)this.dynamicPoolConfiguration);
        jsonWriter.writeJsonField("customContainerTemplate", (JsonSerializable)this.customContainerTemplate);
        jsonWriter.writeJsonField("sessionNetworkConfiguration", (JsonSerializable)this.sessionNetworkConfiguration);
        jsonWriter.writeArrayField("managedIdentitySettings", this.managedIdentitySettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SessionPoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SessionPoolProperties)jsonReader.readObject(reader -> {
            SessionPoolProperties deserializedSessionPoolProperties = new SessionPoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("environmentId".equals(fieldName)) {
                    deserializedSessionPoolProperties.environmentId = reader.getString();
                    continue;
                }
                if ("containerType".equals(fieldName)) {
                    deserializedSessionPoolProperties.containerType = ContainerType.fromString(reader.getString());
                    continue;
                }
                if ("poolManagementType".equals(fieldName)) {
                    deserializedSessionPoolProperties.poolManagementType = PoolManagementType.fromString(reader.getString());
                    continue;
                }
                if ("nodeCount".equals(fieldName)) {
                    deserializedSessionPoolProperties.nodeCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("scaleConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.scaleConfiguration = ScaleConfiguration.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    List secrets;
                    deserializedSessionPoolProperties.secrets = secrets = reader.readArray(reader1 -> SessionPoolSecret.fromJson(reader1));
                    continue;
                }
                if ("dynamicPoolConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.dynamicPoolConfiguration = DynamicPoolConfiguration.fromJson(reader);
                    continue;
                }
                if ("customContainerTemplate".equals(fieldName)) {
                    deserializedSessionPoolProperties.customContainerTemplate = CustomContainerTemplate.fromJson(reader);
                    continue;
                }
                if ("sessionNetworkConfiguration".equals(fieldName)) {
                    deserializedSessionPoolProperties.sessionNetworkConfiguration = SessionNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("poolManagementEndpoint".equals(fieldName)) {
                    deserializedSessionPoolProperties.poolManagementEndpoint = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSessionPoolProperties.provisioningState = SessionPoolProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("managedIdentitySettings".equals(fieldName)) {
                    List managedIdentitySettings;
                    deserializedSessionPoolProperties.managedIdentitySettings = managedIdentitySettings = reader.readArray(reader1 -> ManagedIdentitySetting.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSessionPoolProperties;
        });
    }
}

