/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.JobExecutionRunningState;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class JobExecutionProperties
implements JsonSerializable<JobExecutionProperties> {
    private JobExecutionRunningState status;
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private JobExecutionTemplate template;

    public JobExecutionRunningState status() {
        return this.status;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public JobExecutionProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public JobExecutionProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public JobExecutionTemplate template() {
        return this.template;
    }

    public JobExecutionProperties withTemplate(JobExecutionTemplate template) {
        this.template = template;
        return this;
    }

    public void validate() {
        if (this.template() != null) {
            this.template().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeJsonField("template", (JsonSerializable)this.template);
        return jsonWriter.writeEndObject();
    }

    public static JobExecutionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobExecutionProperties)jsonReader.readObject(reader -> {
            JobExecutionProperties deserializedJobExecutionProperties = new JobExecutionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedJobExecutionProperties.status = JobExecutionRunningState.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedJobExecutionProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("template".equals(fieldName)) {
                    deserializedJobExecutionProperties.template = JobExecutionTemplate.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobExecutionProperties;
        });
    }
}

