/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.fluent.models.JobExecutionProperties;
import com.azure.resourcemanager.appcontainers.models.JobExecutionRunningState;
import com.azure.resourcemanager.appcontainers.models.JobExecutionTemplate;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class JobExecutionInner
implements JsonSerializable<JobExecutionInner> {
    private String name;
    private String id;
    private String type;
    private JobExecutionProperties innerProperties;

    public String name() {
        return this.name;
    }

    public JobExecutionInner withName(String name) {
        this.name = name;
        return this;
    }

    public String id() {
        return this.id;
    }

    public JobExecutionInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public JobExecutionInner withType(String type) {
        this.type = type;
        return this;
    }

    private JobExecutionProperties innerProperties() {
        return this.innerProperties;
    }

    public JobExecutionRunningState status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    public JobExecutionInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobExecutionProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    public JobExecutionInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobExecutionProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    public JobExecutionTemplate template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public JobExecutionInner withTemplate(JobExecutionTemplate template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new JobExecutionProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static JobExecutionInner fromJson(JsonReader jsonReader) throws IOException {
        return (JobExecutionInner)jsonReader.readObject(reader -> {
            JobExecutionInner deserializedJobExecutionInner = new JobExecutionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedJobExecutionInner.name = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedJobExecutionInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedJobExecutionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedJobExecutionInner.innerProperties = JobExecutionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobExecutionInner;
        });
    }
}

