/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appcontainers.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appcontainers.models.ConnectedEnvironmentProvisioningState;
import com.azure.resourcemanager.appcontainers.models.CustomDomainConfiguration;
import java.io.IOException;

public final class ConnectedEnvironmentProperties
implements JsonSerializable<ConnectedEnvironmentProperties> {
    private ConnectedEnvironmentProvisioningState provisioningState;
    private String deploymentErrors;
    private String defaultDomain;
    private String staticIp;
    private String daprAIConnectionString;
    private CustomDomainConfiguration customDomainConfiguration;

    public ConnectedEnvironmentProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String deploymentErrors() {
        return this.deploymentErrors;
    }

    public String defaultDomain() {
        return this.defaultDomain;
    }

    public String staticIp() {
        return this.staticIp;
    }

    public ConnectedEnvironmentProperties withStaticIp(String staticIp) {
        this.staticIp = staticIp;
        return this;
    }

    public String daprAIConnectionString() {
        return this.daprAIConnectionString;
    }

    public ConnectedEnvironmentProperties withDaprAIConnectionString(String daprAIConnectionString) {
        this.daprAIConnectionString = daprAIConnectionString;
        return this;
    }

    public CustomDomainConfiguration customDomainConfiguration() {
        return this.customDomainConfiguration;
    }

    public ConnectedEnvironmentProperties withCustomDomainConfiguration(CustomDomainConfiguration customDomainConfiguration) {
        this.customDomainConfiguration = customDomainConfiguration;
        return this;
    }

    public void validate() {
        if (this.customDomainConfiguration() != null) {
            this.customDomainConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("staticIp", this.staticIp);
        jsonWriter.writeStringField("daprAIConnectionString", this.daprAIConnectionString);
        jsonWriter.writeJsonField("customDomainConfiguration", (JsonSerializable)this.customDomainConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedEnvironmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedEnvironmentProperties)jsonReader.readObject(reader -> {
            ConnectedEnvironmentProperties deserializedConnectedEnvironmentProperties = new ConnectedEnvironmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.provisioningState = ConnectedEnvironmentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("deploymentErrors".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.deploymentErrors = reader.getString();
                    continue;
                }
                if ("defaultDomain".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.defaultDomain = reader.getString();
                    continue;
                }
                if ("staticIp".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.staticIp = reader.getString();
                    continue;
                }
                if ("daprAIConnectionString".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.daprAIConnectionString = reader.getString();
                    continue;
                }
                if ("customDomainConfiguration".equals(fieldName)) {
                    deserializedConnectedEnvironmentProperties.customDomainConfiguration = CustomDomainConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectedEnvironmentProperties;
        });
    }
}

