/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appconfiguration.models.CompositionType;
import com.azure.resourcemanager.appconfiguration.models.KeyValueFilter;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.SnapshotStatus;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Snapshot {
    public String id();

    public String name();

    public String type();

    public ProvisioningState provisioningState();

    public SnapshotStatus status();

    public List<KeyValueFilter> filters();

    public CompositionType compositionType();

    public OffsetDateTime created();

    public OffsetDateTime expires();

    public Long retentionPeriod();

    public Long size();

    public Long itemsCount();

    public Map<String, String> tags();

    public String etag();

    public SnapshotInner innerModel();

    public Snapshot refresh();

    public Snapshot refresh(Context var1);

    public static interface DefinitionStages {

        public static interface WithRetentionPeriod {
            public WithCreate withRetentionPeriod(Long var1);
        }

        public static interface WithCompositionType {
            public WithCreate withCompositionType(CompositionType var1);
        }

        public static interface WithFilters {
            public WithCreate withFilters(List<KeyValueFilter> var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithFilters,
        WithCompositionType,
        WithRetentionPeriod {
            public Snapshot create();

            public Snapshot create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingConfigurationStore(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

