/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.LogSpecification;
import com.azure.resourcemanager.appconfiguration.models.MetricSpecification;
import java.io.IOException;
import java.util.List;

public final class ServiceSpecification
implements JsonSerializable<ServiceSpecification> {
    private List<LogSpecification> logSpecifications;
    private List<MetricSpecification> metricSpecifications;

    public List<LogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public ServiceSpecification withLogSpecifications(List<LogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public List<MetricSpecification> metricSpecifications() {
        return this.metricSpecifications;
    }

    public ServiceSpecification withMetricSpecifications(List<MetricSpecification> metricSpecifications) {
        this.metricSpecifications = metricSpecifications;
        return this;
    }

    public void validate() {
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
        if (this.metricSpecifications() != null) {
            this.metricSpecifications().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metricSpecifications", this.metricSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ServiceSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceSpecification)jsonReader.readObject(reader -> {
            ServiceSpecification deserializedServiceSpecification = new ServiceSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logSpecifications".equals(fieldName)) {
                    List logSpecifications;
                    deserializedServiceSpecification.logSpecifications = logSpecifications = reader.readArray(reader1 -> LogSpecification.fromJson(reader1));
                    continue;
                }
                if ("metricSpecifications".equals(fieldName)) {
                    List metricSpecifications;
                    deserializedServiceSpecification.metricSpecifications = metricSpecifications = reader.readArray(reader1 -> MetricSpecification.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServiceSpecification;
        });
    }
}

