/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.IdentityType;
import com.azure.resourcemanager.appconfiguration.models.UserIdentity;
import java.io.IOException;
import java.util.Map;

public final class ResourceIdentity
implements JsonSerializable<ResourceIdentity> {
    private IdentityType type;
    private Map<String, UserIdentity> userAssignedIdentities;
    private String principalId;
    private String tenantId;

    public IdentityType type() {
        return this.type;
    }

    public ResourceIdentity withType(IdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ResourceIdentity withUserAssignedIdentities(Map<String, UserIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceIdentity)jsonReader.readObject(reader -> {
            ResourceIdentity deserializedResourceIdentity = new ResourceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedResourceIdentity.type = IdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedResourceIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserIdentity.fromJson(reader1));
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedResourceIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedResourceIdentity.tenantId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceIdentity;
        });
    }
}

