/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ReplicaInner;
import java.io.IOException;
import java.util.List;

public final class ReplicaListResult
implements JsonSerializable<ReplicaListResult> {
    private List<ReplicaInner> value;
    private String nextLink;

    public List<ReplicaInner> value() {
        return this.value;
    }

    public ReplicaListResult withValue(List<ReplicaInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ReplicaListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ReplicaListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaListResult)jsonReader.readObject(reader -> {
            ReplicaListResult deserializedReplicaListResult = new ReplicaListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedReplicaListResult.value = value = reader.readArray(reader1 -> ReplicaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedReplicaListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaListResult;
        });
    }
}

