/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.PrivateEndpointConnectionProperties;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpoint;
import com.azure.resourcemanager.appconfiguration.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import java.io.IOException;

public final class PrivateEndpointConnectionReference
implements JsonSerializable<PrivateEndpointConnectionReference> {
    private String id;
    private String name;
    private String type;
    private PrivateEndpointConnectionProperties innerProperties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private PrivateEndpointConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PrivateEndpoint privateEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpoint();
    }

    public PrivateEndpointConnectionReference withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkServiceConnectionState();
    }

    public PrivateEndpointConnectionReference withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateEndpointConnectionProperties();
        }
        this.innerProperties().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PrivateEndpointConnectionReference fromJson(JsonReader jsonReader) throws IOException {
        return (PrivateEndpointConnectionReference)jsonReader.readObject(reader -> {
            PrivateEndpointConnectionReference deserializedPrivateEndpointConnectionReference = new PrivateEndpointConnectionReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionReference.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionReference.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionReference.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPrivateEndpointConnectionReference.innerProperties = PrivateEndpointConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPrivateEndpointConnectionReference;
        });
    }
}

