/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class KeyValueFilter
implements JsonSerializable<KeyValueFilter> {
    private String key;
    private String label;
    private static final ClientLogger LOGGER = new ClientLogger(KeyValueFilter.class);

    public String key() {
        return this.key;
    }

    public KeyValueFilter withKey(String key) {
        this.key = key;
        return this;
    }

    public String label() {
        return this.label;
    }

    public KeyValueFilter withLabel(String label) {
        this.label = label;
        return this;
    }

    public void validate() {
        if (this.key() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property key in model KeyValueFilter"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("key", this.key);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    public static KeyValueFilter fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValueFilter)jsonReader.readObject(reader -> {
            KeyValueFilter deserializedKeyValueFilter = new KeyValueFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyValueFilter.key = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedKeyValueFilter.label = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValueFilter;
        });
    }
}

