/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.AuthenticationMode;
import com.azure.resourcemanager.appconfiguration.models.PrivateLinkDelegation;
import java.io.IOException;

public final class DataPlaneProxyProperties
implements JsonSerializable<DataPlaneProxyProperties> {
    private AuthenticationMode authenticationMode;
    private PrivateLinkDelegation privateLinkDelegation;

    public AuthenticationMode authenticationMode() {
        return this.authenticationMode;
    }

    public DataPlaneProxyProperties withAuthenticationMode(AuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
        return this;
    }

    public PrivateLinkDelegation privateLinkDelegation() {
        return this.privateLinkDelegation;
    }

    public DataPlaneProxyProperties withPrivateLinkDelegation(PrivateLinkDelegation privateLinkDelegation) {
        this.privateLinkDelegation = privateLinkDelegation;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authenticationMode", this.authenticationMode == null ? null : this.authenticationMode.toString());
        jsonWriter.writeStringField("privateLinkDelegation", this.privateLinkDelegation == null ? null : this.privateLinkDelegation.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataPlaneProxyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataPlaneProxyProperties)jsonReader.readObject(reader -> {
            DataPlaneProxyProperties deserializedDataPlaneProxyProperties = new DataPlaneProxyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authenticationMode".equals(fieldName)) {
                    deserializedDataPlaneProxyProperties.authenticationMode = AuthenticationMode.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkDelegation".equals(fieldName)) {
                    deserializedDataPlaneProxyProperties.privateLinkDelegation = PrivateLinkDelegation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataPlaneProxyProperties;
        });
    }
}

