/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStorePropertiesUpdateParameters;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import com.azure.resourcemanager.appconfiguration.models.ResourceIdentity;
import com.azure.resourcemanager.appconfiguration.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class ConfigurationStoreUpdateParameters
implements JsonSerializable<ConfigurationStoreUpdateParameters> {
    private ConfigurationStorePropertiesUpdateParameters innerProperties;
    private ResourceIdentity identity;
    private Sku sku;
    private Map<String, String> tags;

    private ConfigurationStorePropertiesUpdateParameters innerProperties() {
        return this.innerProperties;
    }

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ConfigurationStoreUpdateParameters withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ConfigurationStoreUpdateParameters withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ConfigurationStoreUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public ConfigurationStoreUpdateParameters withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public ConfigurationStoreUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ConfigurationStoreUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePurgeProtection();
    }

    public ConfigurationStoreUpdateParameters withEnablePurgeProtection(Boolean enablePurgeProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withEnablePurgeProtection(enablePurgeProtection);
        return this;
    }

    public DataPlaneProxyProperties dataPlaneProxy() {
        return this.innerProperties() == null ? null : this.innerProperties().dataPlaneProxy();
    }

    public ConfigurationStoreUpdateParameters withDataPlaneProxy(DataPlaneProxyProperties dataPlaneProxy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withDataPlaneProxy(dataPlaneProxy);
        return this;
    }

    public Long defaultKeyValueRevisionRetentionPeriodInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultKeyValueRevisionRetentionPeriodInSeconds();
    }

    public ConfigurationStoreUpdateParameters withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long defaultKeyValueRevisionRetentionPeriodInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStorePropertiesUpdateParameters();
        }
        this.innerProperties().withDefaultKeyValueRevisionRetentionPeriodInSeconds(defaultKeyValueRevisionRetentionPeriodInSeconds);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationStoreUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationStoreUpdateParameters)jsonReader.readObject(reader -> {
            ConfigurationStoreUpdateParameters deserializedConfigurationStoreUpdateParameters = new ConfigurationStoreUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationStoreUpdateParameters.innerProperties = ConfigurationStorePropertiesUpdateParameters.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedConfigurationStoreUpdateParameters.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedConfigurationStoreUpdateParameters.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedConfigurationStoreUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationStoreUpdateParameters;
        });
    }
}

