/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStoreInner;
import java.io.IOException;
import java.util.List;

public final class ConfigurationStoreListResult
implements JsonSerializable<ConfigurationStoreListResult> {
    private List<ConfigurationStoreInner> value;
    private String nextLink;

    public List<ConfigurationStoreInner> value() {
        return this.value;
    }

    public ConfigurationStoreListResult withValue(List<ConfigurationStoreInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ConfigurationStoreListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationStoreListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationStoreListResult)jsonReader.readObject(reader -> {
            ConfigurationStoreListResult deserializedConfigurationStoreListResult = new ConfigurationStoreListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedConfigurationStoreListResult.value = value = reader.readArray(reader1 -> ConfigurationStoreInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedConfigurationStoreListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationStoreListResult;
        });
    }
}

