/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStoreInner;
import com.azure.resourcemanager.appconfiguration.models.ApiKey;
import com.azure.resourcemanager.appconfiguration.models.CreateMode;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnectionReference;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import com.azure.resourcemanager.appconfiguration.models.RegenerateKeyParameters;
import com.azure.resourcemanager.appconfiguration.models.ResourceIdentity;
import com.azure.resourcemanager.appconfiguration.models.Sku;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface ConfigurationStore {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public ResourceIdentity identity();

    public Sku sku();

    public SystemData systemData();

    public ProvisioningState provisioningState();

    public OffsetDateTime creationDate();

    public String endpoint();

    public EncryptionProperties encryption();

    public List<PrivateEndpointConnectionReference> privateEndpointConnections();

    public PublicNetworkAccess publicNetworkAccess();

    public Boolean disableLocalAuth();

    public Integer softDeleteRetentionInDays();

    public Long defaultKeyValueRevisionRetentionPeriodInSeconds();

    public Boolean enablePurgeProtection();

    public DataPlaneProxyProperties dataPlaneProxy();

    public CreateMode createMode();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ConfigurationStoreInner innerModel();

    public Update update();

    public ConfigurationStore refresh();

    public ConfigurationStore refresh(Context var1);

    public PagedIterable<ApiKey> listKeys();

    public PagedIterable<ApiKey> listKeys(String var1, Context var2);

    public Response<ApiKey> regenerateKeyWithResponse(RegenerateKeyParameters var1, Context var2);

    public ApiKey regenerateKey(RegenerateKeyParameters var1);

    public static interface UpdateStages {

        public static interface WithDefaultKeyValueRevisionRetentionPeriodInSeconds {
            public Update withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long var1);
        }

        public static interface WithDataPlaneProxy {
            public Update withDataPlaneProxy(DataPlaneProxyProperties var1);
        }

        public static interface WithEnablePurgeProtection {
            public Update withEnablePurgeProtection(Boolean var1);
        }

        public static interface WithPublicNetworkAccess {
            public Update withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithDisableLocalAuth {
            public Update withDisableLocalAuth(Boolean var1);
        }

        public static interface WithEncryption {
            public Update withEncryption(EncryptionProperties var1);
        }

        public static interface WithSku {
            public Update withSku(Sku var1);
        }

        public static interface WithIdentity {
            public Update withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithIdentity,
    UpdateStages.WithSku,
    UpdateStages.WithEncryption,
    UpdateStages.WithDisableLocalAuth,
    UpdateStages.WithPublicNetworkAccess,
    UpdateStages.WithEnablePurgeProtection,
    UpdateStages.WithDataPlaneProxy,
    UpdateStages.WithDefaultKeyValueRevisionRetentionPeriodInSeconds {
        public ConfigurationStore apply();

        public ConfigurationStore apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithCreateMode {
            public WithCreate withCreateMode(CreateMode var1);
        }

        public static interface WithDataPlaneProxy {
            public WithCreate withDataPlaneProxy(DataPlaneProxyProperties var1);
        }

        public static interface WithEnablePurgeProtection {
            public WithCreate withEnablePurgeProtection(Boolean var1);
        }

        public static interface WithDefaultKeyValueRevisionRetentionPeriodInSeconds {
            public WithCreate withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long var1);
        }

        public static interface WithSoftDeleteRetentionInDays {
            public WithCreate withSoftDeleteRetentionInDays(Integer var1);
        }

        public static interface WithDisableLocalAuth {
            public WithCreate withDisableLocalAuth(Boolean var1);
        }

        public static interface WithPublicNetworkAccess {
            public WithCreate withPublicNetworkAccess(PublicNetworkAccess var1);
        }

        public static interface WithEncryption {
            public WithCreate withEncryption(EncryptionProperties var1);
        }

        public static interface WithIdentity {
            public WithCreate withIdentity(ResourceIdentity var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithIdentity,
        WithEncryption,
        WithPublicNetworkAccess,
        WithDisableLocalAuth,
        WithSoftDeleteRetentionInDays,
        WithDefaultKeyValueRevisionRetentionPeriodInSeconds,
        WithEnablePurgeProtection,
        WithDataPlaneProxy,
        WithCreateMode {
            public ConfigurationStore create();

            public ConfigurationStore create(Context var1);
        }

        public static interface WithSku {
            public WithCreate withSku(Sku var1);
        }

        public static interface WithResourceGroup {
            public WithSku withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithSku,
    DefinitionStages.WithCreate {
    }
}

