/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ApiKeyInner;
import java.io.IOException;
import java.util.List;

public final class ApiKeyListResult
implements JsonSerializable<ApiKeyListResult> {
    private List<ApiKeyInner> value;
    private String nextLink;

    public List<ApiKeyInner> value() {
        return this.value;
    }

    public ApiKeyListResult withValue(List<ApiKeyInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ApiKeyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ApiKeyListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ApiKeyListResult)jsonReader.readObject(reader -> {
            ApiKeyListResult deserializedApiKeyListResult = new ApiKeyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedApiKeyListResult.value = value = reader.readArray(reader1 -> ApiKeyInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedApiKeyListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiKeyListResult;
        });
    }
}

