/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.SnapshotsClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.implementation.SnapshotImpl;
import com.azure.resourcemanager.appconfiguration.models.Snapshot;
import com.azure.resourcemanager.appconfiguration.models.Snapshots;

public final class SnapshotsImpl
implements Snapshots {
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotsImpl.class);
    private final SnapshotsClient innerClient;
    private final AppConfigurationManager serviceManager;

    public SnapshotsImpl(SnapshotsClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Snapshot> getWithResponse(String resourceGroupName, String configStoreName, String snapshotName, Context context) {
        Response<SnapshotInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configStoreName, snapshotName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new SnapshotImpl((SnapshotInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Snapshot get(String resourceGroupName, String configStoreName, String snapshotName) {
        SnapshotInner inner = this.serviceClient().get(resourceGroupName, configStoreName, snapshotName);
        if (inner != null) {
            return new SnapshotImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Snapshot getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return (Snapshot)this.getWithResponse(resourceGroupName, configStoreName, snapshotName, Context.NONE).getValue();
    }

    @Override
    public Response<Snapshot> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String snapshotName = ResourceManagerUtils.getValueFromIdByName(id, "snapshots");
        if (snapshotName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'snapshots'.", id)));
        }
        return this.getWithResponse(resourceGroupName, configStoreName, snapshotName, context);
    }

    private SnapshotsClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl define(String name) {
        return new SnapshotImpl(name, this.manager());
    }
}

