/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appconfiguration.fluent.SnapshotsClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appconfiguration.implementation.AppConfigurationManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SnapshotsClientImpl
implements SnapshotsClient {
    private final SnapshotsService service;
    private final AppConfigurationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotsClientImpl.class);

    SnapshotsClientImpl(AppConfigurationManagementClientImpl client) {
        this.service = (SnapshotsService)RestProxy.create(SnapshotsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SnapshotInner>> getWithResponseAsync(String resourceGroupName, String configStoreName, String snapshotName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, snapshotName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> getAsync(String resourceGroupName, String configStoreName, String snapshotName) {
        return this.getWithResponseAsync(resourceGroupName, configStoreName, snapshotName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((SnapshotInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SnapshotInner> getWithResponse(String resourceGroupName, String configStoreName, String snapshotName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, snapshotName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner get(String resourceGroupName, String configStoreName, String snapshotName) {
        return (SnapshotInner)((Object)this.getWithResponse(resourceGroupName, configStoreName, snapshotName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (snapshotName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, snapshotName, this.client.getApiVersion(), body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, snapshotName, this.client.getApiVersion(), body, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createWithResponse(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (snapshotName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter snapshotName is required and cannot be null."));
        }
        if (body == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return this.service.createSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, snapshotName, this.client.getApiVersion(), body, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginCreateAsync(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, configStoreName, snapshotName, body);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, configStoreName, snapshotName, body);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreate(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body, Context context) {
        Response<BinaryData> response = this.createWithResponse(resourceGroupName, configStoreName, snapshotName, body, context);
        return this.client.getLroResult(response, (Type)((Object)SnapshotInner.class), (Type)((Object)SnapshotInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SnapshotInner> createAsync(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        return this.beginCreateAsync(resourceGroupName, configStoreName, snapshotName, body).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body) {
        return (SnapshotInner)((Object)this.beginCreate(resourceGroupName, configStoreName, snapshotName, body).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SnapshotInner create(String resourceGroupName, String configStoreName, String snapshotName, SnapshotInner body, Context context) {
        return (SnapshotInner)((Object)this.beginCreate(resourceGroupName, configStoreName, snapshotName, body, context).getFinalResult());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppConfigurationMana")
    public static interface SnapshotsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SnapshotInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @PathParam(value="snapshotName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<SnapshotInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @PathParam(value="snapshotName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @PathParam(value="snapshotName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SnapshotInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/snapshots/{snapshotName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @PathParam(value="snapshotName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SnapshotInner var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

