/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appconfiguration.models.CompositionType;
import com.azure.resourcemanager.appconfiguration.models.KeyValueFilter;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.Snapshot;
import com.azure.resourcemanager.appconfiguration.models.SnapshotStatus;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SnapshotImpl
implements Snapshot,
Snapshot.Definition {
    private SnapshotInner innerObject;
    private final AppConfigurationManager serviceManager;
    private String resourceGroupName;
    private String configStoreName;
    private String snapshotName;

    SnapshotImpl(SnapshotInner innerObject, AppConfigurationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public SnapshotStatus status() {
        return this.innerModel().status();
    }

    @Override
    public List<KeyValueFilter> filters() {
        List<KeyValueFilter> inner = this.innerModel().filters();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public CompositionType compositionType() {
        return this.innerModel().compositionType();
    }

    @Override
    public OffsetDateTime created() {
        return this.innerModel().created();
    }

    @Override
    public OffsetDateTime expires() {
        return this.innerModel().expires();
    }

    @Override
    public Long retentionPeriod() {
        return this.innerModel().retentionPeriod();
    }

    @Override
    public Long size() {
        return this.innerModel().size();
    }

    @Override
    public Long itemsCount() {
        return this.innerModel().itemsCount();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public SnapshotInner innerModel() {
        return this.innerObject;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public SnapshotImpl withExistingConfigurationStore(String resourceGroupName, String configStoreName) {
        this.resourceGroupName = resourceGroupName;
        this.configStoreName = configStoreName;
        return this;
    }

    @Override
    public Snapshot create() {
        this.innerObject = this.serviceManager.serviceClient().getSnapshots().create(this.resourceGroupName, this.configStoreName, this.snapshotName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Snapshot create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getSnapshots().create(this.resourceGroupName, this.configStoreName, this.snapshotName, this.innerModel(), context);
        return this;
    }

    SnapshotImpl(String name, AppConfigurationManager serviceManager) {
        this.innerObject = new SnapshotInner();
        this.serviceManager = serviceManager;
        this.snapshotName = name;
    }

    @Override
    public Snapshot refresh() {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getSnapshots().getWithResponse(this.resourceGroupName, this.configStoreName, this.snapshotName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Snapshot refresh(Context context) {
        this.innerObject = (SnapshotInner)((Object)this.serviceManager.serviceClient().getSnapshots().getWithResponse(this.resourceGroupName, this.configStoreName, this.snapshotName, context).getValue());
        return this;
    }

    @Override
    public SnapshotImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public SnapshotImpl withFilters(List<KeyValueFilter> filters) {
        this.innerModel().withFilters(filters);
        return this;
    }

    @Override
    public SnapshotImpl withCompositionType(CompositionType compositionType) {
        this.innerModel().withCompositionType(compositionType);
        return this;
    }

    @Override
    public SnapshotImpl withRetentionPeriod(Long retentionPeriod) {
        this.innerModel().withRetentionPeriod(retentionPeriod);
        return this;
    }
}

