/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.ReplicasClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appconfiguration.implementation.ReplicaImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.Replica;
import com.azure.resourcemanager.appconfiguration.models.Replicas;

public final class ReplicasImpl
implements Replicas {
    private static final ClientLogger LOGGER = new ClientLogger(ReplicasImpl.class);
    private final ReplicasClient innerClient;
    private final AppConfigurationManager serviceManager;

    public ReplicasImpl(ReplicasClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Replica> listByConfigurationStore(String resourceGroupName, String configStoreName) {
        PagedIterable<ReplicaInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReplicaImpl((ReplicaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Replica> listByConfigurationStore(String resourceGroupName, String configStoreName, String skipToken, Context context) {
        PagedIterable<ReplicaInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ReplicaImpl((ReplicaInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Replica> getWithResponse(String resourceGroupName, String configStoreName, String replicaName, Context context) {
        Response<ReplicaInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configStoreName, replicaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ReplicaImpl((ReplicaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Replica get(String resourceGroupName, String configStoreName, String replicaName) {
        ReplicaInner inner = this.serviceClient().get(resourceGroupName, configStoreName, replicaName);
        if (inner != null) {
            return new ReplicaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String replicaName) {
        this.serviceClient().delete(resourceGroupName, configStoreName, replicaName);
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String replicaName, Context context) {
        this.serviceClient().delete(resourceGroupName, configStoreName, replicaName, context);
    }

    @Override
    public Replica getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String replicaName = ResourceManagerUtils.getValueFromIdByName(id, "replicas");
        if (replicaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'replicas'.", id)));
        }
        return (Replica)this.getWithResponse(resourceGroupName, configStoreName, replicaName, Context.NONE).getValue();
    }

    @Override
    public Response<Replica> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String replicaName = ResourceManagerUtils.getValueFromIdByName(id, "replicas");
        if (replicaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'replicas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, configStoreName, replicaName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String replicaName = ResourceManagerUtils.getValueFromIdByName(id, "replicas");
        if (replicaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'replicas'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, replicaName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String replicaName = ResourceManagerUtils.getValueFromIdByName(id, "replicas");
        if (replicaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'replicas'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, replicaName, context);
    }

    private ReplicasClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ReplicaImpl define(String name) {
        return new ReplicaImpl(name, this.manager());
    }
}

