/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.models.ReplicaInner;
import com.azure.resourcemanager.appconfiguration.models.Replica;
import com.azure.resourcemanager.appconfiguration.models.ReplicaProvisioningState;

public final class ReplicaImpl
implements Replica,
Replica.Definition {
    private ReplicaInner innerObject;
    private final AppConfigurationManager serviceManager;
    private String resourceGroupName;
    private String configStoreName;
    private String replicaName;

    ReplicaImpl(ReplicaInner innerObject, AppConfigurationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
    }

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String endpoint() {
        return this.innerModel().endpoint();
    }

    @Override
    public ReplicaProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public ReplicaInner innerModel() {
        return this.innerObject;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ReplicaImpl withExistingConfigurationStore(String resourceGroupName, String configStoreName) {
        this.resourceGroupName = resourceGroupName;
        this.configStoreName = configStoreName;
        return this;
    }

    @Override
    public Replica create() {
        this.innerObject = this.serviceManager.serviceClient().getReplicas().create(this.resourceGroupName, this.configStoreName, this.replicaName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Replica create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getReplicas().create(this.resourceGroupName, this.configStoreName, this.replicaName, this.innerModel(), context);
        return this;
    }

    ReplicaImpl(String name, AppConfigurationManager serviceManager) {
        this.innerObject = new ReplicaInner();
        this.serviceManager = serviceManager;
        this.replicaName = name;
    }

    @Override
    public Replica refresh() {
        this.innerObject = (ReplicaInner)((Object)this.serviceManager.serviceClient().getReplicas().getWithResponse(this.resourceGroupName, this.configStoreName, this.replicaName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Replica refresh(Context context) {
        this.innerObject = (ReplicaInner)((Object)this.serviceManager.serviceClient().getReplicas().getWithResponse(this.resourceGroupName, this.configStoreName, this.replicaName, context).getValue());
        return this;
    }

    @Override
    public ReplicaImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ReplicaImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }
}

