/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.appconfiguration.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.PrivateLinkResource;
import com.azure.resourcemanager.appconfiguration.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final AppConfigurationManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByConfigurationStore(String resourceGroupName, String configStoreName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> listByConfigurationStore(String resourceGroupName, String configStoreName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner1, this.manager()));
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String configStoreName, String groupName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configStoreName, groupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String configStoreName, String groupName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, configStoreName, groupName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }
}

