/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appconfiguration.implementation.PrivateEndpointConnectionImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnection;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnections;

public final class PrivateEndpointConnectionsImpl
implements PrivateEndpointConnections {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateEndpointConnectionsImpl.class);
    private final PrivateEndpointConnectionsClient innerClient;
    private final AppConfigurationManager serviceManager;

    public PrivateEndpointConnectionsImpl(PrivateEndpointConnectionsClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByConfigurationStore(String resourceGroupName, String configStoreName) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateEndpointConnection> listByConfigurationStore(String resourceGroupName, String configStoreName, Context context) {
        PagedIterable<PrivateEndpointConnectionInner> inner = this.serviceClient().listByConfigurationStore(resourceGroupName, configStoreName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<PrivateEndpointConnection> getWithResponse(String resourceGroupName, String configStoreName, String privateEndpointConnectionName, Context context) {
        Response<PrivateEndpointConnectionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configStoreName, privateEndpointConnectionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateEndpointConnectionImpl((PrivateEndpointConnectionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateEndpointConnection get(String resourceGroupName, String configStoreName, String privateEndpointConnectionName) {
        PrivateEndpointConnectionInner inner = this.serviceClient().get(resourceGroupName, configStoreName, privateEndpointConnectionName);
        if (inner != null) {
            return new PrivateEndpointConnectionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String privateEndpointConnectionName) {
        this.serviceClient().delete(resourceGroupName, configStoreName, privateEndpointConnectionName);
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String privateEndpointConnectionName, Context context) {
        this.serviceClient().delete(resourceGroupName, configStoreName, privateEndpointConnectionName, context);
    }

    @Override
    public PrivateEndpointConnection getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return (PrivateEndpointConnection)this.getWithResponse(resourceGroupName, configStoreName, privateEndpointConnectionName, Context.NONE).getValue();
    }

    @Override
    public Response<PrivateEndpointConnection> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        return this.getWithResponse(resourceGroupName, configStoreName, privateEndpointConnectionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, privateEndpointConnectionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(id, "privateEndpointConnections");
        if (privateEndpointConnectionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'privateEndpointConnections'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, privateEndpointConnectionName, context);
    }

    private PrivateEndpointConnectionsClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl define(String name) {
        return new PrivateEndpointConnectionImpl(name, this.manager());
    }
}

