/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpoint;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnection;
import com.azure.resourcemanager.appconfiguration.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;

public final class PrivateEndpointConnectionImpl
implements PrivateEndpointConnection,
PrivateEndpointConnection.Definition,
PrivateEndpointConnection.Update {
    private PrivateEndpointConnectionInner innerObject;
    private final AppConfigurationManager serviceManager;
    private String resourceGroupName;
    private String configStoreName;
    private String privateEndpointConnectionName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public PrivateEndpoint privateEndpoint() {
        return this.innerModel().privateEndpoint();
    }

    @Override
    public PrivateLinkServiceConnectionState privateLinkServiceConnectionState() {
        return this.innerModel().privateLinkServiceConnectionState();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public PrivateEndpointConnectionInner innerModel() {
        return this.innerObject;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public PrivateEndpointConnectionImpl withExistingConfigurationStore(String resourceGroupName, String configStoreName) {
        this.resourceGroupName = resourceGroupName;
        this.configStoreName = configStoreName;
        return this;
    }

    @Override
    public PrivateEndpointConnection create() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(String name, AppConfigurationManager serviceManager) {
        this.innerObject = new PrivateEndpointConnectionInner();
        this.serviceManager = serviceManager;
        this.privateEndpointConnectionName = name;
    }

    @Override
    public PrivateEndpointConnectionImpl update() {
        return this;
    }

    @Override
    public PrivateEndpointConnection apply() {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public PrivateEndpointConnection apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getPrivateEndpointConnections().createOrUpdate(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, this.innerModel(), context);
        return this;
    }

    PrivateEndpointConnectionImpl(PrivateEndpointConnectionInner innerObject, AppConfigurationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.configStoreName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurationStores");
        this.privateEndpointConnectionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "privateEndpointConnections");
    }

    @Override
    public PrivateEndpointConnection refresh() {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, Context.NONE).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnection refresh(Context context) {
        this.innerObject = (PrivateEndpointConnectionInner)((Object)this.serviceManager.serviceClient().getPrivateEndpointConnections().getWithResponse(this.resourceGroupName, this.configStoreName, this.privateEndpointConnectionName, context).getValue());
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateEndpoint(PrivateEndpoint privateEndpoint) {
        this.innerModel().withPrivateEndpoint(privateEndpoint);
        return this;
    }

    @Override
    public PrivateEndpointConnectionImpl withPrivateLinkServiceConnectionState(PrivateLinkServiceConnectionState privateLinkServiceConnectionState) {
        this.innerModel().withPrivateLinkServiceConnectionState(privateLinkServiceConnectionState);
        return this;
    }
}

