/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.OperationsClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.NameAvailabilityStatusInner;
import com.azure.resourcemanager.appconfiguration.fluent.models.OperationDefinitionInner;
import com.azure.resourcemanager.appconfiguration.implementation.NameAvailabilityStatusImpl;
import com.azure.resourcemanager.appconfiguration.implementation.OperationDefinitionImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.appconfiguration.models.NameAvailabilityStatus;
import com.azure.resourcemanager.appconfiguration.models.OperationDefinition;
import com.azure.resourcemanager.appconfiguration.models.Operations;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final AppConfigurationManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<NameAvailabilityStatus> checkNameAvailabilityWithResponse(CheckNameAvailabilityParameters checkNameAvailabilityParameters, Context context) {
        Response<NameAvailabilityStatusInner> inner = this.serviceClient().checkNameAvailabilityWithResponse(checkNameAvailabilityParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityStatusImpl((NameAvailabilityStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityStatus checkNameAvailability(CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        NameAvailabilityStatusInner inner = this.serviceClient().checkNameAvailability(checkNameAvailabilityParameters);
        if (inner != null) {
            return new NameAvailabilityStatusImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<OperationDefinition> list() {
        PagedIterable<OperationDefinitionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationDefinitionImpl((OperationDefinitionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationDefinition> list(String skipToken, Context context) {
        PagedIterable<OperationDefinitionInner> inner = this.serviceClient().list(skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationDefinitionImpl((OperationDefinitionInner)inner1, this.manager()));
    }

    @Override
    public Response<NameAvailabilityStatus> regionalCheckNameAvailabilityWithResponse(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters, Context context) {
        Response<NameAvailabilityStatusInner> inner = this.serviceClient().regionalCheckNameAvailabilityWithResponse(location, checkNameAvailabilityParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new NameAvailabilityStatusImpl((NameAvailabilityStatusInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public NameAvailabilityStatus regionalCheckNameAvailability(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        NameAvailabilityStatusInner inner = this.serviceClient().regionalCheckNameAvailability(location, checkNameAvailabilityParameters);
        if (inner != null) {
            return new NameAvailabilityStatusImpl(inner, this.manager());
        }
        return null;
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }
}

