/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appconfiguration.fluent.OperationsClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.NameAvailabilityStatusInner;
import com.azure.resourcemanager.appconfiguration.fluent.models.OperationDefinitionInner;
import com.azure.resourcemanager.appconfiguration.implementation.AppConfigurationManagementClientImpl;
import com.azure.resourcemanager.appconfiguration.models.CheckNameAvailabilityParameters;
import com.azure.resourcemanager.appconfiguration.models.OperationDefinitionListResult;
import reactor.core.publisher.Mono;

public final class OperationsClientImpl
implements OperationsClient {
    private final OperationsService service;
    private final AppConfigurationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(OperationsClientImpl.class);

    OperationsClientImpl(AppConfigurationManagementClientImpl client) {
        this.service = (OperationsService)RestProxy.create(OperationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityStatusInner>> checkNameAvailabilityWithResponseAsync(CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityParameters is required and cannot be null."));
        }
        checkNameAvailabilityParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkNameAvailability(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), checkNameAvailabilityParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NameAvailabilityStatusInner> checkNameAvailabilityAsync(CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        return this.checkNameAvailabilityWithResponseAsync(checkNameAvailabilityParameters).flatMap(res -> Mono.justOrEmpty((Object)((NameAvailabilityStatusInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NameAvailabilityStatusInner> checkNameAvailabilityWithResponse(CheckNameAvailabilityParameters checkNameAvailabilityParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (checkNameAvailabilityParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter checkNameAvailabilityParameters is required and cannot be null."));
        }
        checkNameAvailabilityParameters.validate();
        String accept = "application/json";
        return this.service.checkNameAvailabilitySync(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), checkNameAvailabilityParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NameAvailabilityStatusInner checkNameAvailability(CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        return (NameAvailabilityStatusInner)this.checkNameAvailabilityWithResponse(checkNameAvailabilityParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationDefinitionInner>> listSinglePageAsync(String skipToken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), skipToken, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationDefinitionInner> listAsync(String skipToken) {
        return new PagedFlux(() -> this.listSinglePageAsync(skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OperationDefinitionInner> listAsync() {
        String skipToken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(skipToken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<OperationDefinitionInner> listSinglePage(String skipToken) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<OperationDefinitionListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), skipToken, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<OperationDefinitionInner> listSinglePage(String skipToken, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<OperationDefinitionListResult> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), skipToken, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationDefinitionInner> list() {
        String skipToken = null;
        return new PagedIterable(() -> this.listSinglePage(skipToken), nextLink -> this.listNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OperationDefinitionInner> list(String skipToken, Context context) {
        return new PagedIterable(() -> this.listSinglePage(skipToken, context), nextLink -> this.listNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityStatusInner>> regionalCheckNameAvailabilityWithResponseAsync(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (checkNameAvailabilityParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter checkNameAvailabilityParameters is required and cannot be null."));
        }
        checkNameAvailabilityParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.regionalCheckNameAvailability(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), checkNameAvailabilityParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NameAvailabilityStatusInner> regionalCheckNameAvailabilityAsync(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        return this.regionalCheckNameAvailabilityWithResponseAsync(location, checkNameAvailabilityParameters).flatMap(res -> Mono.justOrEmpty((Object)((NameAvailabilityStatusInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NameAvailabilityStatusInner> regionalCheckNameAvailabilityWithResponse(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (checkNameAvailabilityParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter checkNameAvailabilityParameters is required and cannot be null."));
        }
        checkNameAvailabilityParameters.validate();
        String accept = "application/json";
        return this.service.regionalCheckNameAvailabilitySync(this.client.getEndpoint(), this.client.getSubscriptionId(), location, this.client.getApiVersion(), checkNameAvailabilityParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NameAvailabilityStatusInner regionalCheckNameAvailability(String location, CheckNameAvailabilityParameters checkNameAvailabilityParameters) {
        return (NameAvailabilityStatusInner)this.regionalCheckNameAvailabilityWithResponse(location, checkNameAvailabilityParameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OperationDefinitionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<OperationDefinitionInner> listNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<OperationDefinitionListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<OperationDefinitionInner> listNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<OperationDefinitionListResult> res = this.service.listNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OperationDefinitionListResult)res.getValue()).value(), ((OperationDefinitionListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppConfigurationMana")
    public static interface OperationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.AppConfiguration/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NameAvailabilityStatusInner>> checkNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckNameAvailabilityParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.AppConfiguration/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NameAvailabilityStatusInner> checkNameAvailabilitySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CheckNameAvailabilityParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.AppConfiguration/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationDefinitionListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$skipToken") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/providers/Microsoft.AppConfiguration/operations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<OperationDefinitionListResult> listSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @QueryParam(value="$skipToken") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.AppConfiguration/locations/{location}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NameAvailabilityStatusInner>> regionalCheckNameAvailability(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CheckNameAvailabilityParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.AppConfiguration/locations/{location}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<NameAvailabilityStatusInner> regionalCheckNameAvailabilitySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") CheckNameAvailabilityParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OperationDefinitionListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<OperationDefinitionListResult> listNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

