/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.KeyValuesClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.KeyValueInner;
import com.azure.resourcemanager.appconfiguration.implementation.KeyValueImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.KeyValue;
import com.azure.resourcemanager.appconfiguration.models.KeyValues;

public final class KeyValuesImpl
implements KeyValues {
    private static final ClientLogger LOGGER = new ClientLogger(KeyValuesImpl.class);
    private final KeyValuesClient innerClient;
    private final AppConfigurationManager serviceManager;

    public KeyValuesImpl(KeyValuesClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<KeyValue> getWithResponse(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        Response<KeyValueInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configStoreName, keyValueName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new KeyValueImpl((KeyValueInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public KeyValue get(String resourceGroupName, String configStoreName, String keyValueName) {
        KeyValueInner inner = this.serviceClient().get(resourceGroupName, configStoreName, keyValueName);
        if (inner != null) {
            return new KeyValueImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String keyValueName) {
        this.serviceClient().delete(resourceGroupName, configStoreName, keyValueName);
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        this.serviceClient().delete(resourceGroupName, configStoreName, keyValueName, context);
    }

    @Override
    public KeyValue getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String keyValueName = ResourceManagerUtils.getValueFromIdByName(id, "keyValues");
        if (keyValueName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keyValues'.", id)));
        }
        return (KeyValue)this.getWithResponse(resourceGroupName, configStoreName, keyValueName, Context.NONE).getValue();
    }

    @Override
    public Response<KeyValue> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String keyValueName = ResourceManagerUtils.getValueFromIdByName(id, "keyValues");
        if (keyValueName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keyValues'.", id)));
        }
        return this.getWithResponse(resourceGroupName, configStoreName, keyValueName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String keyValueName = ResourceManagerUtils.getValueFromIdByName(id, "keyValues");
        if (keyValueName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keyValues'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, keyValueName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        String keyValueName = ResourceManagerUtils.getValueFromIdByName(id, "keyValues");
        if (keyValueName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'keyValues'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, keyValueName, context);
    }

    private KeyValuesClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public KeyValueImpl define(String name) {
        return new KeyValueImpl(name, this.manager());
    }
}

