/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appconfiguration.fluent.KeyValuesClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.KeyValueInner;
import com.azure.resourcemanager.appconfiguration.implementation.AppConfigurationManagementClientImpl;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class KeyValuesClientImpl
implements KeyValuesClient {
    private final KeyValuesService service;
    private final AppConfigurationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(KeyValuesClientImpl.class);

    KeyValuesClientImpl(AppConfigurationManagementClientImpl client) {
        this.service = (KeyValuesService)RestProxy.create(KeyValuesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyValueInner>> getWithResponseAsync(String resourceGroupName, String configStoreName, String keyValueName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KeyValueInner> getAsync(String resourceGroupName, String configStoreName, String keyValueName) {
        return this.getWithResponseAsync(resourceGroupName, configStoreName, keyValueName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((KeyValueInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyValueInner> getWithResponse(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValueInner get(String resourceGroupName, String configStoreName, String keyValueName) {
        return (KeyValueInner)((Object)this.getWithResponse(resourceGroupName, configStoreName, keyValueName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyValueInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String configStoreName, String keyValueName, KeyValueInner keyValueParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        if (keyValueParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyValueParameters is required and cannot be null."));
        }
        keyValueParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, keyValueParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<KeyValueInner> createOrUpdateAsync(String resourceGroupName, String configStoreName, String keyValueName, KeyValueInner keyValueParameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, configStoreName, keyValueName, keyValueParameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((KeyValueInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyValueInner> createOrUpdateWithResponse(String resourceGroupName, String configStoreName, String keyValueName, KeyValueInner keyValueParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        if (keyValueParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter keyValueParameters is required and cannot be null."));
        }
        keyValueParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, keyValueParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyValueInner createOrUpdate(String resourceGroupName, String configStoreName, String keyValueName, KeyValueInner keyValueParameters) {
        return (KeyValueInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, configStoreName, keyValueName, keyValueParameters, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String configStoreName, String keyValueName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String configStoreName, String keyValueName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (configStoreName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter configStoreName is required and cannot be null."));
        }
        if (keyValueName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter keyValueName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, configStoreName, this.client.getApiVersion(), keyValueName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String configStoreName, String keyValueName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, configStoreName, keyValueName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String configStoreName, String keyValueName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, configStoreName, keyValueName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, configStoreName, keyValueName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String configStoreName, String keyValueName) {
        return this.beginDeleteAsync(resourceGroupName, configStoreName, keyValueName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String configStoreName, String keyValueName) {
        this.beginDelete(resourceGroupName, configStoreName, keyValueName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String configStoreName, String keyValueName, Context context) {
        this.beginDelete(resourceGroupName, configStoreName, keyValueName, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppConfigurationMana")
    public static interface KeyValuesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KeyValueInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<KeyValueInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<KeyValueInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @BodyParam(value="application/json") KeyValueInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<KeyValueInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @BodyParam(value="application/json") KeyValueInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppConfiguration/configurationStores/{configStoreName}/keyValues/{keyValueName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="configStoreName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="keyValueName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

