/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.models.KeyValueInner;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.KeyValue;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public final class KeyValueImpl
implements KeyValue,
KeyValue.Definition,
KeyValue.Update {
    private KeyValueInner innerObject;
    private final AppConfigurationManager serviceManager;
    private String resourceGroupName;
    private String configStoreName;
    private String keyValueName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String key() {
        return this.innerModel().key();
    }

    @Override
    public String label() {
        return this.innerModel().label();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public String contentType() {
        return this.innerModel().contentType();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public OffsetDateTime lastModified() {
        return this.innerModel().lastModified();
    }

    @Override
    public Boolean locked() {
        return this.innerModel().locked();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public KeyValueInner innerModel() {
        return this.innerObject;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public KeyValueImpl withExistingConfigurationStore(String resourceGroupName, String configStoreName) {
        this.resourceGroupName = resourceGroupName;
        this.configStoreName = configStoreName;
        return this;
    }

    @Override
    public KeyValue create() {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().createOrUpdateWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public KeyValue create(Context context) {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().createOrUpdateWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, this.innerModel(), context).getValue());
        return this;
    }

    KeyValueImpl(String name, AppConfigurationManager serviceManager) {
        this.innerObject = new KeyValueInner();
        this.serviceManager = serviceManager;
        this.keyValueName = name;
    }

    @Override
    public KeyValueImpl update() {
        return this;
    }

    @Override
    public KeyValue apply() {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().createOrUpdateWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public KeyValue apply(Context context) {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().createOrUpdateWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, this.innerModel(), context).getValue());
        return this;
    }

    KeyValueImpl(KeyValueInner innerObject, AppConfigurationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.configStoreName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurationStores");
        this.keyValueName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "keyValues");
    }

    @Override
    public KeyValue refresh() {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().getWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, Context.NONE).getValue());
        return this;
    }

    @Override
    public KeyValue refresh(Context context) {
        this.innerObject = (KeyValueInner)((Object)this.serviceManager.serviceClient().getKeyValues().getWithResponse(this.resourceGroupName, this.configStoreName, this.keyValueName, context).getValue());
        return this;
    }

    @Override
    public KeyValueImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags(tags);
        return this;
    }

    @Override
    public KeyValueImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public KeyValueImpl withContentType(String contentType) {
        this.innerModel().withContentType(contentType);
        return this;
    }
}

