/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.ConfigurationStoresClient;
import com.azure.resourcemanager.appconfiguration.fluent.models.ApiKeyInner;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStoreInner;
import com.azure.resourcemanager.appconfiguration.fluent.models.DeletedConfigurationStoreInner;
import com.azure.resourcemanager.appconfiguration.implementation.ApiKeyImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ConfigurationStoreImpl;
import com.azure.resourcemanager.appconfiguration.implementation.DeletedConfigurationStoreImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.ApiKey;
import com.azure.resourcemanager.appconfiguration.models.ConfigurationStore;
import com.azure.resourcemanager.appconfiguration.models.ConfigurationStores;
import com.azure.resourcemanager.appconfiguration.models.DeletedConfigurationStore;
import com.azure.resourcemanager.appconfiguration.models.RegenerateKeyParameters;

public final class ConfigurationStoresImpl
implements ConfigurationStores {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationStoresImpl.class);
    private final ConfigurationStoresClient innerClient;
    private final AppConfigurationManager serviceManager;

    public ConfigurationStoresImpl(ConfigurationStoresClient innerClient, AppConfigurationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ConfigurationStore> list() {
        PagedIterable<ConfigurationStoreInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationStoreImpl((ConfigurationStoreInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationStore> list(String skipToken, Context context) {
        PagedIterable<ConfigurationStoreInner> inner = this.serviceClient().list(skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationStoreImpl((ConfigurationStoreInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationStore> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ConfigurationStoreInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationStoreImpl((ConfigurationStoreInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigurationStore> listByResourceGroup(String resourceGroupName, String skipToken, Context context) {
        PagedIterable<ConfigurationStoreInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigurationStoreImpl((ConfigurationStoreInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ConfigurationStore> getByResourceGroupWithResponse(String resourceGroupName, String configStoreName, Context context) {
        Response<ConfigurationStoreInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, configStoreName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationStoreImpl((ConfigurationStoreInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigurationStore getByResourceGroup(String resourceGroupName, String configStoreName) {
        ConfigurationStoreInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, configStoreName);
        if (inner != null) {
            return new ConfigurationStoreImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String configStoreName) {
        this.serviceClient().delete(resourceGroupName, configStoreName);
    }

    @Override
    public void delete(String resourceGroupName, String configStoreName, Context context) {
        this.serviceClient().delete(resourceGroupName, configStoreName, context);
    }

    @Override
    public PagedIterable<ApiKey> listKeys(String resourceGroupName, String configStoreName) {
        PagedIterable<ApiKeyInner> inner = this.serviceClient().listKeys(resourceGroupName, configStoreName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiKeyImpl((ApiKeyInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ApiKey> listKeys(String resourceGroupName, String configStoreName, String skipToken, Context context) {
        PagedIterable<ApiKeyInner> inner = this.serviceClient().listKeys(resourceGroupName, configStoreName, skipToken, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ApiKeyImpl((ApiKeyInner)inner1, this.manager()));
    }

    @Override
    public Response<ApiKey> regenerateKeyWithResponse(String resourceGroupName, String configStoreName, RegenerateKeyParameters regenerateKeyParameters, Context context) {
        Response<ApiKeyInner> inner = this.serviceClient().regenerateKeyWithResponse(resourceGroupName, configStoreName, regenerateKeyParameters, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApiKeyImpl((ApiKeyInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ApiKey regenerateKey(String resourceGroupName, String configStoreName, RegenerateKeyParameters regenerateKeyParameters) {
        ApiKeyInner inner = this.serviceClient().regenerateKey(resourceGroupName, configStoreName, regenerateKeyParameters);
        if (inner != null) {
            return new ApiKeyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<DeletedConfigurationStore> listDeleted() {
        PagedIterable<DeletedConfigurationStoreInner> inner = this.serviceClient().listDeleted();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedConfigurationStoreImpl((DeletedConfigurationStoreInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<DeletedConfigurationStore> listDeleted(Context context) {
        PagedIterable<DeletedConfigurationStoreInner> inner = this.serviceClient().listDeleted(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DeletedConfigurationStoreImpl((DeletedConfigurationStoreInner)inner1, this.manager()));
    }

    @Override
    public Response<DeletedConfigurationStore> getDeletedWithResponse(String location, String configStoreName, Context context) {
        Response<DeletedConfigurationStoreInner> inner = this.serviceClient().getDeletedWithResponse(location, configStoreName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DeletedConfigurationStoreImpl((DeletedConfigurationStoreInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public DeletedConfigurationStore getDeleted(String location, String configStoreName) {
        DeletedConfigurationStoreInner inner = this.serviceClient().getDeleted(location, configStoreName);
        if (inner != null) {
            return new DeletedConfigurationStoreImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void purgeDeleted(String location, String configStoreName) {
        this.serviceClient().purgeDeleted(location, configStoreName);
    }

    @Override
    public void purgeDeleted(String location, String configStoreName, Context context) {
        this.serviceClient().purgeDeleted(location, configStoreName, context);
    }

    @Override
    public ConfigurationStore getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        return (ConfigurationStore)this.getByResourceGroupWithResponse(resourceGroupName, configStoreName, Context.NONE).getValue();
    }

    @Override
    public Response<ConfigurationStore> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, configStoreName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String configStoreName = ResourceManagerUtils.getValueFromIdByName(id, "configurationStores");
        if (configStoreName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurationStores'.", id)));
        }
        this.delete(resourceGroupName, configStoreName, context);
    }

    private ConfigurationStoresClient serviceClient() {
        return this.innerClient;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationStoreImpl define(String name) {
        return new ConfigurationStoreImpl(name, this.manager());
    }
}

