/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.appconfiguration.AppConfigurationManager;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStoreInner;
import com.azure.resourcemanager.appconfiguration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.appconfiguration.models.ApiKey;
import com.azure.resourcemanager.appconfiguration.models.ConfigurationStore;
import com.azure.resourcemanager.appconfiguration.models.ConfigurationStoreUpdateParameters;
import com.azure.resourcemanager.appconfiguration.models.CreateMode;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnectionReference;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import com.azure.resourcemanager.appconfiguration.models.RegenerateKeyParameters;
import com.azure.resourcemanager.appconfiguration.models.ResourceIdentity;
import com.azure.resourcemanager.appconfiguration.models.Sku;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ConfigurationStoreImpl
implements ConfigurationStore,
ConfigurationStore.Definition,
ConfigurationStore.Update {
    private ConfigurationStoreInner innerObject;
    private final AppConfigurationManager serviceManager;
    private String resourceGroupName;
    private String configStoreName;
    private ConfigurationStoreUpdateParameters updateConfigStoreUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ResourceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public ProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public OffsetDateTime creationDate() {
        return this.innerModel().creationDate();
    }

    @Override
    public String endpoint() {
        return this.innerModel().endpoint();
    }

    @Override
    public EncryptionProperties encryption() {
        return this.innerModel().encryption();
    }

    @Override
    public List<PrivateEndpointConnectionReference> privateEndpointConnections() {
        List<PrivateEndpointConnectionReference> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public Boolean disableLocalAuth() {
        return this.innerModel().disableLocalAuth();
    }

    @Override
    public Integer softDeleteRetentionInDays() {
        return this.innerModel().softDeleteRetentionInDays();
    }

    @Override
    public Long defaultKeyValueRevisionRetentionPeriodInSeconds() {
        return this.innerModel().defaultKeyValueRevisionRetentionPeriodInSeconds();
    }

    @Override
    public Boolean enablePurgeProtection() {
        return this.innerModel().enablePurgeProtection();
    }

    @Override
    public DataPlaneProxyProperties dataPlaneProxy() {
        return this.innerModel().dataPlaneProxy();
    }

    @Override
    public CreateMode createMode() {
        return this.innerModel().createMode();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ConfigurationStoreInner innerModel() {
        return this.innerObject;
    }

    private AppConfigurationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationStoreImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ConfigurationStore create() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurationStores().create(this.resourceGroupName, this.configStoreName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ConfigurationStore create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurationStores().create(this.resourceGroupName, this.configStoreName, this.innerModel(), context);
        return this;
    }

    ConfigurationStoreImpl(String name, AppConfigurationManager serviceManager) {
        this.innerObject = new ConfigurationStoreInner();
        this.serviceManager = serviceManager;
        this.configStoreName = name;
    }

    @Override
    public ConfigurationStoreImpl update() {
        this.updateConfigStoreUpdateParameters = new ConfigurationStoreUpdateParameters();
        return this;
    }

    @Override
    public ConfigurationStore apply() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurationStores().update(this.resourceGroupName, this.configStoreName, this.updateConfigStoreUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public ConfigurationStore apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurationStores().update(this.resourceGroupName, this.configStoreName, this.updateConfigStoreUpdateParameters, context);
        return this;
    }

    ConfigurationStoreImpl(ConfigurationStoreInner innerObject, AppConfigurationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.configStoreName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "configurationStores");
    }

    @Override
    public ConfigurationStore refresh() {
        this.innerObject = (ConfigurationStoreInner)((Object)this.serviceManager.serviceClient().getConfigurationStores().getByResourceGroupWithResponse(this.resourceGroupName, this.configStoreName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ConfigurationStore refresh(Context context) {
        this.innerObject = (ConfigurationStoreInner)((Object)this.serviceManager.serviceClient().getConfigurationStores().getByResourceGroupWithResponse(this.resourceGroupName, this.configStoreName, context).getValue());
        return this;
    }

    @Override
    public PagedIterable<ApiKey> listKeys() {
        return this.serviceManager.configurationStores().listKeys(this.resourceGroupName, this.configStoreName);
    }

    @Override
    public PagedIterable<ApiKey> listKeys(String skipToken, Context context) {
        return this.serviceManager.configurationStores().listKeys(this.resourceGroupName, this.configStoreName, skipToken, context);
    }

    @Override
    public Response<ApiKey> regenerateKeyWithResponse(RegenerateKeyParameters regenerateKeyParameters, Context context) {
        return this.serviceManager.configurationStores().regenerateKeyWithResponse(this.resourceGroupName, this.configStoreName, regenerateKeyParameters, context);
    }

    @Override
    public ApiKey regenerateKey(RegenerateKeyParameters regenerateKeyParameters) {
        return this.serviceManager.configurationStores().regenerateKey(this.resourceGroupName, this.configStoreName, regenerateKeyParameters);
    }

    @Override
    public ConfigurationStoreImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ConfigurationStoreImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withSku(sku);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withIdentity(ResourceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withEncryption(EncryptionProperties encryption) {
        if (this.isInCreateMode()) {
            this.innerModel().withEncryption(encryption);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withEncryption(encryption);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.isInCreateMode()) {
            this.innerModel().withPublicNetworkAccess(publicNetworkAccess);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.isInCreateMode()) {
            this.innerModel().withDisableLocalAuth(disableLocalAuth);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.innerModel().withSoftDeleteRetentionInDays(softDeleteRetentionInDays);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long defaultKeyValueRevisionRetentionPeriodInSeconds) {
        if (this.isInCreateMode()) {
            this.innerModel().withDefaultKeyValueRevisionRetentionPeriodInSeconds(defaultKeyValueRevisionRetentionPeriodInSeconds);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withDefaultKeyValueRevisionRetentionPeriodInSeconds(defaultKeyValueRevisionRetentionPeriodInSeconds);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withEnablePurgeProtection(Boolean enablePurgeProtection) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnablePurgeProtection(enablePurgeProtection);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withEnablePurgeProtection(enablePurgeProtection);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withDataPlaneProxy(DataPlaneProxyProperties dataPlaneProxy) {
        if (this.isInCreateMode()) {
            this.innerModel().withDataPlaneProxy(dataPlaneProxy);
            return this;
        }
        this.updateConfigStoreUpdateParameters.withDataPlaneProxy(dataPlaneProxy);
        return this;
    }

    @Override
    public ConfigurationStoreImpl withCreateMode(CreateMode createMode) {
        this.innerModel().withCreateMode(createMode);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

