/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.appconfiguration.fluent.AppConfigurationManagementClient;
import com.azure.resourcemanager.appconfiguration.fluent.ConfigurationStoresClient;
import com.azure.resourcemanager.appconfiguration.fluent.KeyValuesClient;
import com.azure.resourcemanager.appconfiguration.fluent.OperationsClient;
import com.azure.resourcemanager.appconfiguration.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.appconfiguration.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.appconfiguration.fluent.ReplicasClient;
import com.azure.resourcemanager.appconfiguration.fluent.SnapshotsClient;
import com.azure.resourcemanager.appconfiguration.implementation.AppConfigurationManagementClientBuilder;
import com.azure.resourcemanager.appconfiguration.implementation.ConfigurationStoresClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.KeyValuesClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.OperationsClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.ReplicasClientImpl;
import com.azure.resourcemanager.appconfiguration.implementation.SnapshotsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=AppConfigurationManagementClientBuilder.class)
public final class AppConfigurationManagementClientImpl
implements AppConfigurationManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ConfigurationStoresClient configurationStores;
    private final OperationsClient operations;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final KeyValuesClient keyValues;
    private final ReplicasClient replicas;
    private final SnapshotsClient snapshots;
    private static final ClientLogger LOGGER = new ClientLogger(AppConfigurationManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ConfigurationStoresClient getConfigurationStores() {
        return this.configurationStores;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public KeyValuesClient getKeyValues() {
        return this.keyValues;
    }

    @Override
    public ReplicasClient getReplicas() {
        return this.replicas;
    }

    @Override
    public SnapshotsClient getSnapshots() {
        return this.snapshots;
    }

    AppConfigurationManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2024-06-01";
        this.configurationStores = new ConfigurationStoresClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.keyValues = new KeyValuesClientImpl(this);
        this.replicas = new ReplicasClientImpl(this);
        this.snapshots = new SnapshotsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

