/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.CompositionType;
import com.azure.resourcemanager.appconfiguration.models.KeyValueFilter;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.SnapshotStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SnapshotProperties
implements JsonSerializable<SnapshotProperties> {
    private ProvisioningState provisioningState;
    private SnapshotStatus status;
    private List<KeyValueFilter> filters;
    private CompositionType compositionType;
    private OffsetDateTime created;
    private OffsetDateTime expires;
    private Long retentionPeriod;
    private Long size;
    private Long itemsCount;
    private Map<String, String> tags;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(SnapshotProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SnapshotStatus status() {
        return this.status;
    }

    public List<KeyValueFilter> filters() {
        return this.filters;
    }

    public SnapshotProperties withFilters(List<KeyValueFilter> filters) {
        this.filters = filters;
        return this;
    }

    public CompositionType compositionType() {
        return this.compositionType;
    }

    public SnapshotProperties withCompositionType(CompositionType compositionType) {
        this.compositionType = compositionType;
        return this;
    }

    public OffsetDateTime created() {
        return this.created;
    }

    public OffsetDateTime expires() {
        return this.expires;
    }

    public Long retentionPeriod() {
        return this.retentionPeriod;
    }

    public SnapshotProperties withRetentionPeriod(Long retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
        return this;
    }

    public Long size() {
        return this.size;
    }

    public Long itemsCount() {
        return this.itemsCount;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SnapshotProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public void validate() {
        if (this.filters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filters in model SnapshotProperties"));
        }
        this.filters().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("compositionType", this.compositionType == null ? null : this.compositionType.toString());
        jsonWriter.writeNumberField("retentionPeriod", (Number)this.retentionPeriod);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SnapshotProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotProperties)jsonReader.readObject(reader -> {
            SnapshotProperties deserializedSnapshotProperties = new SnapshotProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedSnapshotProperties.filters = filters = reader.readArray(reader1 -> KeyValueFilter.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedSnapshotProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSnapshotProperties.status = SnapshotStatus.fromString(reader.getString());
                    continue;
                }
                if ("compositionType".equals(fieldName)) {
                    deserializedSnapshotProperties.compositionType = CompositionType.fromString(reader.getString());
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSnapshotProperties.created = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expires".equals(fieldName)) {
                    deserializedSnapshotProperties.expires = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("retentionPeriod".equals(fieldName)) {
                    deserializedSnapshotProperties.retentionPeriod = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedSnapshotProperties.size = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("itemsCount".equals(fieldName)) {
                    deserializedSnapshotProperties.itemsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSnapshotProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSnapshotProperties.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotProperties;
        });
    }
}

