/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.SnapshotProperties;
import com.azure.resourcemanager.appconfiguration.models.CompositionType;
import com.azure.resourcemanager.appconfiguration.models.KeyValueFilter;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.SnapshotStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SnapshotInner
extends ProxyResource {
    private SnapshotProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SnapshotProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SnapshotStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public List<KeyValueFilter> filters() {
        return this.innerProperties() == null ? null : this.innerProperties().filters();
    }

    public SnapshotInner withFilters(List<KeyValueFilter> filters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withFilters(filters);
        return this;
    }

    public CompositionType compositionType() {
        return this.innerProperties() == null ? null : this.innerProperties().compositionType();
    }

    public SnapshotInner withCompositionType(CompositionType compositionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withCompositionType(compositionType);
        return this;
    }

    public OffsetDateTime created() {
        return this.innerProperties() == null ? null : this.innerProperties().created();
    }

    public OffsetDateTime expires() {
        return this.innerProperties() == null ? null : this.innerProperties().expires();
    }

    public Long retentionPeriod() {
        return this.innerProperties() == null ? null : this.innerProperties().retentionPeriod();
    }

    public SnapshotInner withRetentionPeriod(Long retentionPeriod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withRetentionPeriod(retentionPeriod);
        return this;
    }

    public Long size() {
        return this.innerProperties() == null ? null : this.innerProperties().size();
    }

    public Long itemsCount() {
        return this.innerProperties() == null ? null : this.innerProperties().itemsCount();
    }

    public Map<String, String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public SnapshotInner withTags(Map<String, String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public String etag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotInner fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotInner)((Object)jsonReader.readObject(reader -> {
            SnapshotInner deserializedSnapshotInner = new SnapshotInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSnapshotInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSnapshotInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnapshotInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotInner.innerProperties = SnapshotProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotInner;
        }));
    }
}

