/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ReplicaProperties;
import com.azure.resourcemanager.appconfiguration.models.ReplicaProvisioningState;
import java.io.IOException;

public final class ReplicaInner
extends ProxyResource {
    private String location;
    private SystemData systemData;
    private ReplicaProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public String location() {
        return this.location;
    }

    public ReplicaInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private ReplicaProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String endpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoint();
    }

    public ReplicaProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    public static ReplicaInner fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicaInner)((Object)jsonReader.readObject(reader -> {
            ReplicaInner deserializedReplicaInner = new ReplicaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedReplicaInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedReplicaInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedReplicaInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedReplicaInner.location = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedReplicaInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReplicaInner.innerProperties = ReplicaProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicaInner;
        }));
    }
}

