/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.OperationDefinitionDisplay;
import com.azure.resourcemanager.appconfiguration.models.OperationProperties;
import java.io.IOException;

public final class OperationDefinitionInner
implements JsonSerializable<OperationDefinitionInner> {
    private String name;
    private Boolean isDataAction;
    private OperationDefinitionDisplay display;
    private String origin;
    private OperationProperties properties;

    public String name() {
        return this.name;
    }

    public OperationDefinitionInner withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationDefinitionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationDefinitionDisplay display() {
        return this.display;
    }

    public OperationDefinitionInner withDisplay(OperationDefinitionDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public OperationDefinitionInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public OperationProperties properties() {
        return this.properties;
    }

    public OperationDefinitionInner withProperties(OperationProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static OperationDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationDefinitionInner)jsonReader.readObject(reader -> {
            OperationDefinitionInner deserializedOperationDefinitionInner = new OperationDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationDefinitionInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationDefinitionInner.display = OperationDefinitionDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationDefinitionInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationDefinitionInner.properties = OperationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationDefinitionInner;
        });
    }
}

