/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class KeyValueProperties
implements JsonSerializable<KeyValueProperties> {
    private String key;
    private String label;
    private String value;
    private String contentType;
    private String etag;
    private OffsetDateTime lastModified;
    private Boolean locked;
    private Map<String, String> tags;

    public String key() {
        return this.key;
    }

    public String label() {
        return this.label;
    }

    public String value() {
        return this.value;
    }

    public KeyValueProperties withValue(String value) {
        this.value = value;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public KeyValueProperties withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public Boolean locked() {
        return this.locked;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public KeyValueProperties withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KeyValueProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValueProperties)jsonReader.readObject(reader -> {
            KeyValueProperties deserializedKeyValueProperties = new KeyValueProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedKeyValueProperties.key = reader.getString();
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedKeyValueProperties.label = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedKeyValueProperties.value = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedKeyValueProperties.contentType = reader.getString();
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedKeyValueProperties.etag = reader.getString();
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedKeyValueProperties.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("locked".equals(fieldName)) {
                    deserializedKeyValueProperties.locked = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyValueProperties.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValueProperties;
        });
    }
}

