/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.KeyValueProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class KeyValueInner
extends ProxyResource {
    private KeyValueProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private KeyValueProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String key() {
        return this.innerProperties() == null ? null : this.innerProperties().key();
    }

    public String label() {
        return this.innerProperties() == null ? null : this.innerProperties().label();
    }

    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    public KeyValueInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyValueProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    public String contentType() {
        return this.innerProperties() == null ? null : this.innerProperties().contentType();
    }

    public KeyValueInner withContentType(String contentType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyValueProperties();
        }
        this.innerProperties().withContentType(contentType);
        return this;
    }

    public String etag() {
        return this.innerProperties() == null ? null : this.innerProperties().etag();
    }

    public OffsetDateTime lastModified() {
        return this.innerProperties() == null ? null : this.innerProperties().lastModified();
    }

    public Boolean locked() {
        return this.innerProperties() == null ? null : this.innerProperties().locked();
    }

    public Map<String, String> tags() {
        return this.innerProperties() == null ? null : this.innerProperties().tags();
    }

    public KeyValueInner withTags(Map<String, String> tags) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KeyValueProperties();
        }
        this.innerProperties().withTags(tags);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KeyValueInner fromJson(JsonReader jsonReader) throws IOException {
        return (KeyValueInner)((Object)jsonReader.readObject(reader -> {
            KeyValueInner deserializedKeyValueInner = new KeyValueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKeyValueInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKeyValueInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKeyValueInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKeyValueInner.innerProperties = KeyValueProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyValueInner;
        }));
    }
}

