/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import java.io.IOException;

public final class ConfigurationStorePropertiesUpdateParameters
implements JsonSerializable<ConfigurationStorePropertiesUpdateParameters> {
    private EncryptionProperties encryption;
    private Boolean disableLocalAuth;
    private PublicNetworkAccess publicNetworkAccess;
    private Boolean enablePurgeProtection;
    private DataPlaneProxyProperties dataPlaneProxy;
    private Long defaultKeyValueRevisionRetentionPeriodInSeconds;

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public ConfigurationStorePropertiesUpdateParameters withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public ConfigurationStorePropertiesUpdateParameters withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ConfigurationStorePropertiesUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public ConfigurationStorePropertiesUpdateParameters withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public DataPlaneProxyProperties dataPlaneProxy() {
        return this.dataPlaneProxy;
    }

    public ConfigurationStorePropertiesUpdateParameters withDataPlaneProxy(DataPlaneProxyProperties dataPlaneProxy) {
        this.dataPlaneProxy = dataPlaneProxy;
        return this;
    }

    public Long defaultKeyValueRevisionRetentionPeriodInSeconds() {
        return this.defaultKeyValueRevisionRetentionPeriodInSeconds;
    }

    public ConfigurationStorePropertiesUpdateParameters withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long defaultKeyValueRevisionRetentionPeriodInSeconds) {
        this.defaultKeyValueRevisionRetentionPeriodInSeconds = defaultKeyValueRevisionRetentionPeriodInSeconds;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.dataPlaneProxy() != null) {
            this.dataPlaneProxy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("enablePurgeProtection", this.enablePurgeProtection);
        jsonWriter.writeJsonField("dataPlaneProxy", (JsonSerializable)this.dataPlaneProxy);
        jsonWriter.writeNumberField("defaultKeyValueRevisionRetentionPeriodInSeconds", (Number)this.defaultKeyValueRevisionRetentionPeriodInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationStorePropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationStorePropertiesUpdateParameters)jsonReader.readObject(reader -> {
            ConfigurationStorePropertiesUpdateParameters deserializedConfigurationStorePropertiesUpdateParameters = new ConfigurationStorePropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encryption".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("enablePurgeProtection".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.enablePurgeProtection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataPlaneProxy".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.dataPlaneProxy = DataPlaneProxyProperties.fromJson(reader);
                    continue;
                }
                if ("defaultKeyValueRevisionRetentionPeriodInSeconds".equals(fieldName)) {
                    deserializedConfigurationStorePropertiesUpdateParameters.defaultKeyValueRevisionRetentionPeriodInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationStorePropertiesUpdateParameters;
        });
    }
}

