/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.models.CreateMode;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnectionReference;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ConfigurationStoreProperties
implements JsonSerializable<ConfigurationStoreProperties> {
    private ProvisioningState provisioningState;
    private OffsetDateTime creationDate;
    private String endpoint;
    private EncryptionProperties encryption;
    private List<PrivateEndpointConnectionReference> privateEndpointConnections;
    private PublicNetworkAccess publicNetworkAccess;
    private Boolean disableLocalAuth;
    private Integer softDeleteRetentionInDays;
    private Long defaultKeyValueRevisionRetentionPeriodInSeconds;
    private Boolean enablePurgeProtection;
    private DataPlaneProxyProperties dataPlaneProxy;
    private CreateMode createMode;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public EncryptionProperties encryption() {
        return this.encryption;
    }

    public ConfigurationStoreProperties withEncryption(EncryptionProperties encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionReference> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ConfigurationStoreProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public ConfigurationStoreProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.softDeleteRetentionInDays;
    }

    public ConfigurationStoreProperties withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        this.softDeleteRetentionInDays = softDeleteRetentionInDays;
        return this;
    }

    public Long defaultKeyValueRevisionRetentionPeriodInSeconds() {
        return this.defaultKeyValueRevisionRetentionPeriodInSeconds;
    }

    public ConfigurationStoreProperties withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long defaultKeyValueRevisionRetentionPeriodInSeconds) {
        this.defaultKeyValueRevisionRetentionPeriodInSeconds = defaultKeyValueRevisionRetentionPeriodInSeconds;
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.enablePurgeProtection;
    }

    public ConfigurationStoreProperties withEnablePurgeProtection(Boolean enablePurgeProtection) {
        this.enablePurgeProtection = enablePurgeProtection;
        return this;
    }

    public DataPlaneProxyProperties dataPlaneProxy() {
        return this.dataPlaneProxy;
    }

    public ConfigurationStoreProperties withDataPlaneProxy(DataPlaneProxyProperties dataPlaneProxy) {
        this.dataPlaneProxy = dataPlaneProxy;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public ConfigurationStoreProperties withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.dataPlaneProxy() != null) {
            this.dataPlaneProxy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeNumberField("softDeleteRetentionInDays", (Number)this.softDeleteRetentionInDays);
        jsonWriter.writeNumberField("defaultKeyValueRevisionRetentionPeriodInSeconds", (Number)this.defaultKeyValueRevisionRetentionPeriodInSeconds);
        jsonWriter.writeBooleanField("enablePurgeProtection", this.enablePurgeProtection);
        jsonWriter.writeJsonField("dataPlaneProxy", (JsonSerializable)this.dataPlaneProxy);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationStoreProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationStoreProperties)jsonReader.readObject(reader -> {
            ConfigurationStoreProperties deserializedConfigurationStoreProperties = new ConfigurationStoreProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endpoint".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.endpoint = reader.getString();
                    continue;
                }
                if ("encryption".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.encryption = EncryptionProperties.fromJson(reader);
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedConfigurationStoreProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionReference.fromJson(reader1));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("softDeleteRetentionInDays".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.softDeleteRetentionInDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("defaultKeyValueRevisionRetentionPeriodInSeconds".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.defaultKeyValueRevisionRetentionPeriodInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("enablePurgeProtection".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.enablePurgeProtection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("dataPlaneProxy".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.dataPlaneProxy = DataPlaneProxyProperties.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedConfigurationStoreProperties.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationStoreProperties;
        });
    }
}

