/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appconfiguration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appconfiguration.fluent.models.ConfigurationStoreProperties;
import com.azure.resourcemanager.appconfiguration.models.CreateMode;
import com.azure.resourcemanager.appconfiguration.models.DataPlaneProxyProperties;
import com.azure.resourcemanager.appconfiguration.models.EncryptionProperties;
import com.azure.resourcemanager.appconfiguration.models.PrivateEndpointConnectionReference;
import com.azure.resourcemanager.appconfiguration.models.ProvisioningState;
import com.azure.resourcemanager.appconfiguration.models.PublicNetworkAccess;
import com.azure.resourcemanager.appconfiguration.models.ResourceIdentity;
import com.azure.resourcemanager.appconfiguration.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ConfigurationStoreInner
extends Resource {
    private ResourceIdentity identity;
    private ConfigurationStoreProperties innerProperties;
    private Sku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationStoreInner.class);

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ConfigurationStoreInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ConfigurationStoreProperties innerProperties() {
        return this.innerProperties;
    }

    public Sku sku() {
        return this.sku;
    }

    public ConfigurationStoreInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConfigurationStoreInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConfigurationStoreInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public String endpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().endpoint();
    }

    public EncryptionProperties encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public ConfigurationStoreInner withEncryption(EncryptionProperties encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionReference> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ConfigurationStoreInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public ConfigurationStoreInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public Integer softDeleteRetentionInDays() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeleteRetentionInDays();
    }

    public ConfigurationStoreInner withSoftDeleteRetentionInDays(Integer softDeleteRetentionInDays) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withSoftDeleteRetentionInDays(softDeleteRetentionInDays);
        return this;
    }

    public Long defaultKeyValueRevisionRetentionPeriodInSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultKeyValueRevisionRetentionPeriodInSeconds();
    }

    public ConfigurationStoreInner withDefaultKeyValueRevisionRetentionPeriodInSeconds(Long defaultKeyValueRevisionRetentionPeriodInSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withDefaultKeyValueRevisionRetentionPeriodInSeconds(defaultKeyValueRevisionRetentionPeriodInSeconds);
        return this;
    }

    public Boolean enablePurgeProtection() {
        return this.innerProperties() == null ? null : this.innerProperties().enablePurgeProtection();
    }

    public ConfigurationStoreInner withEnablePurgeProtection(Boolean enablePurgeProtection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withEnablePurgeProtection(enablePurgeProtection);
        return this;
    }

    public DataPlaneProxyProperties dataPlaneProxy() {
        return this.innerProperties() == null ? null : this.innerProperties().dataPlaneProxy();
    }

    public ConfigurationStoreInner withDataPlaneProxy(DataPlaneProxyProperties dataPlaneProxy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withDataPlaneProxy(dataPlaneProxy);
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public ConfigurationStoreInner withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConfigurationStoreProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ConfigurationStoreInner"));
        }
        this.sku().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationStoreInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationStoreInner)((Object)jsonReader.readObject(reader -> {
            ConfigurationStoreInner deserializedConfigurationStoreInner = new ConfigurationStoreInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigurationStoreInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConfigurationStoreInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConfigurationStoreInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedConfigurationStoreInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConfigurationStoreInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedConfigurationStoreInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedConfigurationStoreInner.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationStoreInner.innerProperties = ConfigurationStoreProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConfigurationStoreInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationStoreInner;
        }));
    }
}

